/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.network;

import net.exavior.oeuvre.gui.menu.ArtistDeskMenu;
import net.exavior.oeuvre.item.SketchBookPaperItem;
import net.exavior.oeuvre.network.client.CTSSaveSketchPacket;
import net.exavior.oeuvre.network.client.CTSUpdateResolutionPacket;
import net.exavior.oeuvre.registry.OeuvDataComponents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class OeuvServerHandler {
    private static final OeuvServerHandler INSTANCE = new OeuvServerHandler();

    public static OeuvServerHandler getInstance() {
        return INSTANCE;
    }

    public void handleSaveSketch(CTSSaveSketchPacket data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            ItemStack stack = player.getMainHandItem();
            if (stack.getItem() instanceof SketchBookPaperItem) {
                stack.set(OeuvDataComponents.SKETCH_DATA, data.pixels());
            }
        });
    }

    public void handleUpdateResolution(CTSUpdateResolutionPacket data, IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            AbstractContainerMenu patt0$temp = player.containerMenu;
            if (patt0$temp instanceof ArtistDeskMenu) {
                ArtistDeskMenu menu = (ArtistDeskMenu)patt0$temp;
                menu.setResolution(data.resolution());
            }
        });
    }
}

