/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.registry;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Iterator;
import java.util.List;
import net.exavior.oeuvre.gui.renderer.SketchTextureManager;
import net.exavior.oeuvre.registry.OeuvDataComponents;
import net.exavior.oeuvre.registry.OeuvItems;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderItemInFrameEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(modid="oeuvre", value={Dist.CLIENT})
public class OeuvClientEvents {
    @SubscribeEvent
    public static void onRenderItemInFrame(RenderItemInFrameEvent event) {
        if (event.getItemStack().getItem() == OeuvItems.SKETCHBOOK_PAPER.get()) {
            List pixels = (List)event.getItemStack().get(OeuvDataComponents.SKETCH_DATA);
            if (pixels == null || pixels.isEmpty()) {
                return;
            }
            boolean hasDrawing = false;
            Iterator iterator = pixels.iterator();
            while (iterator.hasNext()) {
                int color = (Integer)iterator.next();
                if (color == 0) continue;
                hasDrawing = true;
                break;
            }
            if (!hasDrawing) {
                return;
            }
            ResourceLocation texture = SketchTextureManager.getTexture(pixels);
            if (texture == null) {
                return;
            }
            event.setCanceled(true);
            PoseStack poseStack = event.getPoseStack();
            MultiBufferSource bufferSource = event.getMultiBufferSource();
            poseStack.pushPose();
            poseStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
            float scale = 1.0f;
            poseStack.scale(scale, scale, scale);
            poseStack.translate(0.0f, 0.0f, -0.01f);
            VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)texture));
            Matrix4f pose = poseStack.last().pose();
            int light = event.getPackedLight();
            float s = 0.5f;
            vertexConsumer.addVertex(pose, -s, s, 0.0f).setColor(-1).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
            vertexConsumer.addVertex(pose, s, s, 0.0f).setColor(-1).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
            vertexConsumer.addVertex(pose, s, -s, 0.0f).setColor(-1).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
            vertexConsumer.addVertex(pose, -s, -s, 0.0f).setColor(-1).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(poseStack.last(), 0.0f, 0.0f, 1.0f);
            poseStack.popPose();
        }
    }
}

