/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.registry;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class OeuvDataComponents {
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"oeuvre");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<Integer>>> SKETCH_DATA = OeuvDataComponents.register("sketch_data", builder -> builder.persistent(Codec.INT.listOf()).networkSynchronized(ByteBufCodecs.collection(ArrayList::new, (StreamCodec)ByteBufCodecs.INT)));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<ItemStack>>> STORED_PAPERS = OeuvDataComponents.register("stored_papers", builder -> builder.persistent(ItemStack.CODEC.listOf()).networkSynchronized(ItemStack.LIST_STREAM_CODEC));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<List<ItemStack>>> STICKER_LIST = OeuvDataComponents.register("sticker_list", builder -> builder.persistent(ItemStack.OPTIONAL_CODEC.listOf()).networkSynchronized(ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list())));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> RESOLUTION = OeuvDataComponents.register("resolution", builder -> builder.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.INT));

    private static <T> DeferredHolder<DataComponentType<?>, DataComponentType<T>> register(String name, UnaryOperator<DataComponentType.Builder<T>> builderOperator) {
        return DATA_COMPONENT_TYPES.register(name, () -> ((DataComponentType.Builder)builderOperator.apply(DataComponentType.builder())).build());
    }

    public static void register(IEventBus eventBus) {
        DATA_COMPONENT_TYPES.register(eventBus);
    }
}

