/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.registry;

import java.util.function.Supplier;
import net.exavior.oeuvre.entity.custom.AnimatingItemFrameEntity;
import net.exavior.oeuvre.entity.custom.IllustratorEntity;
import net.exavior.oeuvre.entity.custom.IllustratorPaperEntity;
import net.exavior.oeuvre.entity.custom.IllustratorVexEntity;
import net.exavior.oeuvre.entity.custom.SketchBookPaperEntity;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class OeuvEntityTypes {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"oeuvre");
    public static final DeferredHolder<EntityType<?>, EntityType<SketchBookPaperEntity>> SKETCHBOOK_PAPER = ENTITY_TYPES.register("sketchbook_paper", () -> EntityType.Builder.of(SketchBookPaperEntity::new, (MobCategory)MobCategory.MISC).sized(0.6f, 1.8f).clientTrackingRange(12).build(OeuvEntityTypes.dataFixer("sketchbook_paper")));
    public static final DeferredHolder<EntityType<?>, EntityType<IllustratorEntity>> ILLUSTRATOR = ENTITY_TYPES.register("illustrator", () -> EntityType.Builder.of(IllustratorEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.8f).clientTrackingRange(12).build(OeuvEntityTypes.dataFixer("illustrator")));
    public static final DeferredHolder<EntityType<?>, EntityType<IllustratorPaperEntity>> ILLUSTRATOR_PAPER = ENTITY_TYPES.register("illustrator_paper", () -> EntityType.Builder.of(IllustratorPaperEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.8f).clientTrackingRange(12).build(OeuvEntityTypes.dataFixer("illustrator_paper")));
    public static final DeferredHolder<EntityType<?>, EntityType<IllustratorVexEntity>> ILLUSTRATOR_VEX = ENTITY_TYPES.register("illustrator_vex", () -> EntityType.Builder.of(IllustratorVexEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.4f, 0.8f).clientTrackingRange(8).build(OeuvEntityTypes.dataFixer("illustrator_vex")));
    public static final Supplier<EntityType<AnimatingItemFrameEntity>> ANIMATING_ITEM_FRAME = ENTITY_TYPES.register("animating_item_frame", () -> EntityType.Builder.of(AnimatingItemFrameEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(10).updateInterval(Integer.MAX_VALUE).build("animating_item_frame"));

    public static void register(IEventBus eventBus) {
        ENTITY_TYPES.register(eventBus);
    }

    private static String dataFixer(String mobName) {
        return "oeuvre:" + mobName;
    }
}

