/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.registry;

import java.util.List;
import java.util.function.Supplier;
import net.exavior.oeuvre.registry.OeuvItems;
import net.exavior.oeuvre.registry.OeuvVillagers;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.village.VillagerTradesEvent;

@EventBusSubscriber(modid="oeuvre")
public class OeuvVillagerTrades {
    private static final List<Supplier<Item>> HABITAT_STICKER_POOL = List.of(OeuvItems.STICKER_AIR, OeuvItems.STICKER_WATER, OeuvItems.STICKER_NETHER, OeuvItems.STICKER_AMPHIBIAN);
    private static final List<Supplier<Item>> ATTACK_STICKER_POOL = List.of(OeuvItems.STICKER_MELEE, OeuvItems.STICKER_BOW);

    @SubscribeEvent
    public static void addCustomTrades(VillagerTradesEvent event) {
        if (event.getType() == OeuvVillagers.DESIGNER.get()) {
            ((List)event.getTrades().get(1)).add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.PAPER, 16), 16, 2, 0.05f));
            ((List)event.getTrades().get(1)).add((pTrader, pRandom) -> {
                Item sticker = HABITAT_STICKER_POOL.get(pRandom.nextInt(HABITAT_STICKER_POOL.size())).get();
                return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 24), new ItemStack((ItemLike)sticker, 1), 3, 5, 0.05f);
            });
            ((List)event.getTrades().get(2)).add((pTrader, pRandom) -> {
                DyeColor randomColor = DyeColor.byId((int)pRandom.nextInt(16));
                DyeItem dyeItem = DyeItem.byColor((DyeColor)randomColor);
                return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 4), new ItemStack((ItemLike)dyeItem, 4), 8, 5, 0.05f);
            });
            ((List)event.getTrades().get(3)).add((pTrader, pRandom) -> {
                Item sticker = ATTACK_STICKER_POOL.get(pRandom.nextInt(ATTACK_STICKER_POOL.size())).get();
                return new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 32), new ItemStack((ItemLike)sticker, 1), 1, 30, 0.05f);
            });
            ((List)event.getTrades().get(4)).add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 1), new ItemStack((ItemLike)Items.BOOK, 2), 12, 15, 0.05f));
            ((List)event.getTrades().get(5)).add((pTrader, pRandom) -> new MerchantOffer(new ItemCost((ItemLike)Items.EMERALD, 16), new ItemStack((ItemLike)OeuvItems.LIVING_INK.get(), 1), 4, 10, 0.05f));
        }
    }
}

