/*
 * Decompiled with CFR 0.152.
 */
package net.exavior.oeuvre.util;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public class IllustratorPixelManager {
    private static final Map<Integer, List<Integer>> LOADED_VARIATIONS = new HashMap<Integer, List<Integer>>();
    private static final String BASE_PATH = "assets/oeuvre/textures/entity/illustrator/paper_variations/";
    public static final int VEX_ID = 4;

    public static void loadVariations() {
        LOADED_VARIATIONS.clear();
        for (int i = 1; i <= 3; ++i) {
            String path = "assets/oeuvre/textures/entity/illustrator/paper_variations/variation_" + i + ".png";
            List<Integer> pixels = IllustratorPixelManager.loadPixels(path);
            if (pixels.isEmpty()) continue;
            LOADED_VARIATIONS.put(i, pixels);
        }
        String vexPath = "assets/oeuvre/textures/entity/illustrator/paper_variations/vex_variation_3.png";
        List<Integer> vexPixels = IllustratorPixelManager.loadPixels(vexPath);
        if (!vexPixels.isEmpty()) {
            LOADED_VARIATIONS.put(4, vexPixels);
        }
    }

    public static List<Integer> getVariation(int id) {
        return LOADED_VARIATIONS.getOrDefault(id, Collections.emptyList());
    }

    public static Collection<Integer> getBossSummonIDs() {
        ArrayList<Integer> ids = new ArrayList<Integer>(LOADED_VARIATIONS.keySet());
        ids.remove((Object)4);
        return ids;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<Integer> loadPixels(String path) {
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);){
            if (is == null) {
                List<Integer> list = Collections.emptyList();
                return list;
            }
            BufferedImage image = ImageIO.read(is);
            if (image == null) {
                List<Integer> list = Collections.emptyList();
                return list;
            }
            int width = image.getWidth();
            int height = image.getHeight();
            ArrayList<Integer> pixels = new ArrayList<Integer>(Collections.nCopies(1024, 0));
            for (int y = 0; y < Math.min(height, 32); ++y) {
                for (int x = 0; x < Math.min(width, 32); ++x) {
                    int color = image.getRGB(x, y);
                    pixels.set(y * 32 + x, color);
                }
            }
            ArrayList<Integer> arrayList = pixels;
            return arrayList;
        }
        catch (IOException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }
}

