/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sketchybooks.client;

import com.mojang.logging.LogUtils;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="sketchy_books", value={Dist.CLIENT})
public class BookSigningHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private static CompoundTag pendingDrawings = null;
    @Nullable
    private static InteractionHand pendingHand = null;
    private static int ticksToWait = 0;

    public static void savePendingDrawings(CompoundTag drawings, InteractionHand hand) {
        pendingDrawings = drawings;
        pendingHand = hand;
        ticksToWait = 2;
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (ticksToWait > 0 && --ticksToWait == 0 && pendingDrawings != null) {
            BookSigningHandler.applyDrawingsToSignedBook();
        }
    }

    private static void applyDrawingsToSignedBook() {
        try {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            ItemStack signedBook = player.m_21120_(pendingHand);
            if (!signedBook.m_150930_(Items.f_42615_)) {
                return;
            }
            CompoundTag bookTag = signedBook.m_41784_();
            bookTag.m_128365_("SketchyBooks", (Tag)pendingDrawings);
        }
        catch (Exception e) {
            LOGGER.error("Erreur lors de l'application des dessins au livre sign\u00e9", (Throwable)e);
        }
        finally {
            pendingDrawings = null;
            pendingHand = null;
        }
    }
}

