/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sketchybooks.data;

import javax.annotation.Nullable;
import net.mcreator.sketchybooks.data.DrawingData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class BookDrawingStorage {
    private static final String NBT_ROOT_KEY = "SketchyBooks";
    private static final String NBT_DRAWINGS_KEY = "drawings";
    private static final String PAGE_KEY_PREFIX = "page_";

    public static void saveDrawing(ItemStack book, int page, DrawingData drawing) {
        BookDrawingStorage.validateBook(book);
        BookDrawingStorage.validatePageNumber(page);
        if (drawing == null) {
            throw new IllegalArgumentException("Les donn\u00e9es de dessin ne peuvent pas \u00eatre null");
        }
        CompoundTag bookTag = book.m_41784_();
        CompoundTag sketchyBooksTag = bookTag.m_128469_(NBT_ROOT_KEY);
        if (!bookTag.m_128441_(NBT_ROOT_KEY)) {
            bookTag.m_128365_(NBT_ROOT_KEY, (Tag)sketchyBooksTag);
        }
        CompoundTag drawingsTag = sketchyBooksTag.m_128469_(NBT_DRAWINGS_KEY);
        if (!sketchyBooksTag.m_128441_(NBT_DRAWINGS_KEY)) {
            sketchyBooksTag.m_128365_(NBT_DRAWINGS_KEY, (Tag)drawingsTag);
        }
        String pageKey = BookDrawingStorage.getPageKey(page);
        drawingsTag.m_128365_(pageKey, (Tag)drawing.toNBT());
    }

    @Nullable
    public static DrawingData loadDrawing(ItemStack book, int page) {
        String pageKey;
        BookDrawingStorage.validateBook(book);
        BookDrawingStorage.validatePageNumber(page);
        CompoundTag bookTag = book.m_41783_();
        if (bookTag == null || !bookTag.m_128441_(NBT_ROOT_KEY)) {
            return null;
        }
        CompoundTag sketchyBooksTag = bookTag.m_128469_(NBT_ROOT_KEY);
        if (!sketchyBooksTag.m_128441_(NBT_DRAWINGS_KEY)) {
            return null;
        }
        CompoundTag drawingsTag = sketchyBooksTag.m_128469_(NBT_DRAWINGS_KEY);
        if (!drawingsTag.m_128441_(pageKey = BookDrawingStorage.getPageKey(page))) {
            return null;
        }
        CompoundTag drawingTag = drawingsTag.m_128469_(pageKey);
        return DrawingData.fromNBT(drawingTag);
    }

    public static boolean hasDrawing(ItemStack book, int page) {
        BookDrawingStorage.validateBook(book);
        BookDrawingStorage.validatePageNumber(page);
        CompoundTag bookTag = book.m_41783_();
        if (bookTag == null || !bookTag.m_128441_(NBT_ROOT_KEY)) {
            return false;
        }
        CompoundTag sketchyBooksTag = bookTag.m_128469_(NBT_ROOT_KEY);
        if (!sketchyBooksTag.m_128441_(NBT_DRAWINGS_KEY)) {
            return false;
        }
        CompoundTag drawingsTag = sketchyBooksTag.m_128469_(NBT_DRAWINGS_KEY);
        String pageKey = BookDrawingStorage.getPageKey(page);
        return drawingsTag.m_128441_(pageKey);
    }

    public static void removeDrawing(ItemStack book, int page) {
        BookDrawingStorage.validateBook(book);
        BookDrawingStorage.validatePageNumber(page);
        CompoundTag bookTag = book.m_41783_();
        if (bookTag == null || !bookTag.m_128441_(NBT_ROOT_KEY)) {
            return;
        }
        CompoundTag sketchyBooksTag = bookTag.m_128469_(NBT_ROOT_KEY);
        if (!sketchyBooksTag.m_128441_(NBT_DRAWINGS_KEY)) {
            return;
        }
        CompoundTag drawingsTag = sketchyBooksTag.m_128469_(NBT_DRAWINGS_KEY);
        String pageKey = BookDrawingStorage.getPageKey(page);
        drawingsTag.m_128473_(pageKey);
        if (drawingsTag.m_128456_()) {
            sketchyBooksTag.m_128473_(NBT_DRAWINGS_KEY);
        }
        if (sketchyBooksTag.m_128456_()) {
            bookTag.m_128473_(NBT_ROOT_KEY);
        }
    }

    public static int getDrawingCount(ItemStack book) {
        BookDrawingStorage.validateBook(book);
        CompoundTag bookTag = book.m_41783_();
        if (bookTag == null || !bookTag.m_128441_(NBT_ROOT_KEY)) {
            return 0;
        }
        CompoundTag sketchyBooksTag = bookTag.m_128469_(NBT_ROOT_KEY);
        if (!sketchyBooksTag.m_128441_(NBT_DRAWINGS_KEY)) {
            return 0;
        }
        CompoundTag drawingsTag = sketchyBooksTag.m_128469_(NBT_DRAWINGS_KEY);
        return drawingsTag.m_128440_();
    }

    public static int[] getDrawingPages(ItemStack book) {
        BookDrawingStorage.validateBook(book);
        CompoundTag bookTag = book.m_41783_();
        if (bookTag == null || !bookTag.m_128441_(NBT_ROOT_KEY)) {
            return new int[0];
        }
        CompoundTag sketchyBooksTag = bookTag.m_128469_(NBT_ROOT_KEY);
        if (!sketchyBooksTag.m_128441_(NBT_DRAWINGS_KEY)) {
            return new int[0];
        }
        CompoundTag drawingsTag = sketchyBooksTag.m_128469_(NBT_DRAWINGS_KEY);
        return drawingsTag.m_128431_().stream().filter(key -> key.startsWith(PAGE_KEY_PREFIX)).mapToInt(key -> {
            try {
                return Integer.parseInt(key.substring(PAGE_KEY_PREFIX.length()));
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }).filter(page -> page >= 0).sorted().toArray();
    }

    public static void clearAllDrawings(ItemStack book) {
        BookDrawingStorage.validateBook(book);
        CompoundTag bookTag = book.m_41783_();
        if (bookTag != null && bookTag.m_128441_(NBT_ROOT_KEY)) {
            bookTag.m_128473_(NBT_ROOT_KEY);
        }
    }

    public static void copyAllDrawings(ItemStack source, ItemStack destination) {
        BookDrawingStorage.validateBook(source);
        BookDrawingStorage.validateBook(destination);
        CompoundTag sourceTag = source.m_41783_();
        if (sourceTag == null || !sourceTag.m_128441_(NBT_ROOT_KEY)) {
            return;
        }
        CompoundTag sketchyBooksTag = sourceTag.m_128469_(NBT_ROOT_KEY).m_6426_();
        CompoundTag destTag = destination.m_41784_();
        destTag.m_128365_(NBT_ROOT_KEY, (Tag)sketchyBooksTag);
    }

    private static String getPageKey(int page) {
        return PAGE_KEY_PREFIX + page;
    }

    private static void validateBook(ItemStack book) {
        if (book == null || book.m_41619_()) {
            throw new IllegalArgumentException("L'ItemStack du livre ne peut pas \u00eatre null ou vide");
        }
        if (!BookDrawingStorage.isValidBookItem(book)) {
            throw new IllegalArgumentException("L'ItemStack doit \u00eatre un livre inscriptible ou \u00e9crit (WRITABLE_BOOK ou WRITTEN_BOOK), actuel: " + book.m_41720_().toString());
        }
    }

    private static boolean isValidBookItem(ItemStack book) {
        return book.m_150930_(Items.f_42614_) || book.m_150930_(Items.f_42615_);
    }

    private static void validatePageNumber(int page) {
        if (page < 0) {
            throw new IllegalArgumentException("Le num\u00e9ro de page ne peut pas \u00eatre n\u00e9gatif: " + page);
        }
    }
}

