/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sketchybooks.network;

import java.util.function.Supplier;
import net.mcreator.sketchybooks.SketchyBooksMod;
import net.mcreator.sketchybooks.data.BookDrawingStorage;
import net.mcreator.sketchybooks.data.DrawingData;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.network.NetworkEvent;

public class DrawingPacket {
    private final DrawingData drawing;
    private final int pageNumber;
    private final boolean isMainHand;

    public DrawingPacket(DrawingData drawing, int pageNumber, boolean isMainHand) {
        if (drawing == null) {
            throw new IllegalArgumentException("DrawingData ne peut pas \u00eatre null");
        }
        if (pageNumber < 0) {
            throw new IllegalArgumentException("Le num\u00e9ro de page doit \u00eatre >= 0");
        }
        this.drawing = drawing;
        this.pageNumber = pageNumber;
        this.isMainHand = isMainHand;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.pageNumber);
        buffer.writeBoolean(this.isMainHand);
        buffer.m_130079_(this.drawing.toNBT());
    }

    public static DrawingPacket decode(FriendlyByteBuf buffer) {
        try {
            int pageNumber = buffer.readInt();
            boolean isMainHand = buffer.readBoolean();
            DrawingData drawing = DrawingData.fromNBT(buffer.m_130260_());
            return new DrawingPacket(drawing, pageNumber, isMainHand);
        }
        catch (Exception e) {
            SketchyBooksMod.LOGGER.error("Erreur lors de la d\u00e9s\u00e9rialisation du DrawingPacket", (Throwable)e);
            return new DrawingPacket(new DrawingData(), 0, true);
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> {
                ServerPlayer player = context.getSender();
                if (player == null) {
                    SketchyBooksMod.LOGGER.warn("DrawingPacket re\u00e7u sans joueur exp\u00e9diteur");
                    return;
                }
                InteractionHand hand = this.isMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
                ItemStack bookStack = player.m_21120_(hand);
                if (bookStack.m_41619_() || !bookStack.m_150930_(Items.f_42614_)) {
                    SketchyBooksMod.LOGGER.warn("Le joueur {} a essay\u00e9 de sauvegarder un dessin sans tenir de livre inscriptible dans la {} main", (Object)player.m_7755_().getString(), (Object)(this.isMainHand ? "principale" : "secondaire"));
                    return;
                }
                if (this.pageNumber < 0 || this.pageNumber >= 100) {
                    SketchyBooksMod.LOGGER.warn("Le joueur {} a essay\u00e9 de sauvegarder un dessin sur une page invalide: {}", (Object)player.m_7755_().getString(), (Object)this.pageNumber);
                    return;
                }
                if (!DrawingPacket.isValidDrawing(this.drawing)) {
                    SketchyBooksMod.LOGGER.warn("Le joueur {} a envoy\u00e9 des donn\u00e9es de dessin invalides", (Object)player.m_7755_().getString());
                    return;
                }
                try {
                    BookDrawingStorage.saveDrawing(bookStack, this.pageNumber, this.drawing);
                    SketchyBooksMod.LOGGER.info("Dessin sauvegard\u00e9 pour le joueur {} sur la page {} (vide: {})", (Object)player.m_7755_().getString(), (Object)this.pageNumber, (Object)this.drawing.isEmpty());
                }
                catch (Exception e) {
                    SketchyBooksMod.LOGGER.error("Erreur lors de la sauvegarde du dessin pour le joueur " + player.m_7755_().getString(), (Throwable)e);
                }
            });
        }
        context.setPacketHandled(true);
    }

    private static boolean isValidDrawing(DrawingData drawing) {
        if (drawing == null) {
            return false;
        }
        try {
            for (int y = 0; y < 16; ++y) {
                for (int x = 0; x < 16; ++x) {
                    int colorIndex = drawing.getPixel(x, y);
                    if (colorIndex >= 0 && colorIndex < 16) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            SketchyBooksMod.LOGGER.error("Erreur lors de la validation du dessin", (Throwable)e);
            return false;
        }
    }

    public DrawingData getDrawing() {
        return this.drawing;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public boolean isMainHand() {
        return this.isMainHand;
    }
}

