/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sketchybooks.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import net.mcreator.sketchybooks.client.gui.ColorButton;
import net.mcreator.sketchybooks.data.ColorPalette;
import net.mcreator.sketchybooks.data.DrawingData;
import net.mcreator.sketchybooks.network.DrawingPacket;
import net.mcreator.sketchybooks.network.NetworkHandler;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;

public class DrawingScreen
extends Screen {
    private final DrawingData drawingData;
    private final int pageNumber;
    private final InteractionHand hand;
    private ColorPalette selectedColor;
    private boolean eraserMode;
    private final List<ColorButton> colorButtons;
    private static final int CELL_SIZE = 12;
    private int gridStartX;
    private int gridStartY;
    private static final int GRID_PIXEL_SIZE = 192;
    private boolean isDrawing;
    private Button eraserButton;
    private Button saveButton;
    private Button clearButton;
    private Button cancelButton;

    public DrawingScreen(DrawingData initialData, int pageNumber, InteractionHand hand) {
        super((Component)Component.m_237110_((String)"gui.sketchy_books.drawing.title", (Object[])new Object[]{pageNumber + 1}));
        this.drawingData = initialData != null ? initialData.copy() : new DrawingData();
        this.pageNumber = pageNumber;
        this.hand = hand;
        this.selectedColor = ColorPalette.BLACK;
        this.eraserMode = false;
        this.isDrawing = false;
        this.colorButtons = new ArrayList<ColorButton>();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.gridStartX = (this.f_96543_ - 192) / 2;
        this.gridStartY = 40;
        int paletteX = this.gridStartX + 192 + 20;
        int paletteY = this.gridStartY;
        this.colorButtons.clear();
        ColorPalette[] colors = ColorPalette.values();
        for (int i = 0; i < colors.length; ++i) {
            int row = i / 4;
            int col = i % 4;
            int x = paletteX + col * 24;
            int y = paletteY + row * 24;
            ColorButton colorButton = new ColorButton(x, y, colors[i], button -> this.onColorSelected(((ColorButton)button).getColor()));
            if (colors[i] == this.selectedColor && !this.eraserMode) {
                colorButton.setSelected(true);
            }
            this.colorButtons.add(colorButton);
            this.m_142416_((GuiEventListener)colorButton);
        }
        int buttonY = Math.min(this.gridStartY + 192 + 40, this.f_96544_ - 30);
        int buttonSpacing = 90;
        int buttonStartX = this.f_96543_ / 2 - buttonSpacing * 2 + 20;
        this.cancelButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.sketchy_books.drawing.cancel"), button -> this.onCancel()).m_252987_(buttonStartX, buttonY, 80, 20).m_253136_());
        this.eraserButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.sketchy_books.drawing.eraser"), button -> this.toggleEraser()).m_252987_(buttonStartX + buttonSpacing, buttonY, 80, 20).m_253136_());
        this.clearButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.sketchy_books.drawing.clear"), button -> this.onClearAll()).m_252987_(buttonStartX + buttonSpacing * 2, buttonY, 80, 20).m_253136_());
        this.saveButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.sketchy_books.drawing.save"), button -> this.onSave()).m_252987_(buttonStartX + buttonSpacing * 3, buttonY, 80, 20).m_253136_());
    }

    public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(poseStack);
        this.renderGrid(poseStack);
        DrawingScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
        String toolText = this.eraserMode ? Component.m_237115_((String)"gui.sketchy_books.drawing.eraser").getString() : Component.m_237115_((String)"gui.sketchy_books.drawing.tool.pencil").getString();
        DrawingScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)(Component.m_237115_((String)"gui.sketchy_books.drawing.tool.current").getString() + ": " + toolText), (int)(this.gridStartX + 192 + 20), (int)(this.gridStartY + 110), (int)0xFFFFFF);
        super.m_86412_(poseStack, mouseX, mouseY, partialTick);
    }

    private void renderGrid(PoseStack poseStack) {
        int x;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(this.gridStartX - 2), (int)(this.gridStartY - 2), (int)(this.gridStartX + 192 + 2), (int)(this.gridStartY + 192 + 2), (int)-16777216);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)this.gridStartX, (int)this.gridStartY, (int)(this.gridStartX + 192), (int)(this.gridStartY + 192), (int)-1);
        for (int y = 0; y < 16; ++y) {
            for (x = 0; x < 16; ++x) {
                int colorIndex = this.drawingData.getPixel(x, y);
                ColorPalette color = ColorPalette.fromIndex(colorIndex);
                int pixelX = this.gridStartX + x * 12;
                int pixelY = this.gridStartY + y * 12;
                GuiComponent.m_93172_((PoseStack)poseStack, (int)pixelX, (int)pixelY, (int)(pixelX + 12), (int)(pixelY + 12), (int)(0xFF000000 | color.getRgbValue()));
            }
        }
        for (int i = 0; i <= 16; ++i) {
            x = this.gridStartX + i * 12;
            GuiComponent.m_93172_((PoseStack)poseStack, (int)x, (int)this.gridStartY, (int)(x + 1), (int)(this.gridStartY + 192), (int)Integer.MIN_VALUE);
            int y = this.gridStartY + i * 12;
            GuiComponent.m_93172_((PoseStack)poseStack, (int)this.gridStartX, (int)y, (int)(this.gridStartX + 192), (int)(y + 1), (int)Integer.MIN_VALUE);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.isMouseOverGrid(mouseX, mouseY) && button == 0) {
            this.isDrawing = true;
            this.drawAtPosition(mouseX, mouseY);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDrawing = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDrawing && button == 0 && this.isMouseOverGrid(mouseX, mouseY)) {
            this.drawAtPosition(mouseX, mouseY);
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    private boolean isMouseOverGrid(double mouseX, double mouseY) {
        return mouseX >= (double)this.gridStartX && mouseX < (double)(this.gridStartX + 192) && mouseY >= (double)this.gridStartY && mouseY < (double)(this.gridStartY + 192);
    }

    private void drawAtPosition(double mouseX, double mouseY) {
        int gridX = (int)((mouseX - (double)this.gridStartX) / 12.0);
        int gridY = (int)((mouseY - (double)this.gridStartY) / 12.0);
        if (gridX >= 0 && gridX < 16 && gridY >= 0 && gridY < 16) {
            ColorPalette colorToUse = this.eraserMode ? ColorPalette.WHITE : this.selectedColor;
            this.drawingData.setPixel(gridX, gridY, colorToUse.getIndex());
        }
    }

    private void onColorSelected(ColorPalette color) {
        this.selectedColor = color;
        this.eraserMode = false;
        this.updateColorButtonSelection();
    }

    private void toggleEraser() {
        this.eraserMode = !this.eraserMode;
        this.updateColorButtonSelection();
    }

    private void updateColorButtonSelection() {
        for (ColorButton button : this.colorButtons) {
            button.setSelected(!this.eraserMode && button.getColor() == this.selectedColor);
        }
    }

    private void onClearAll() {
        this.drawingData.clear();
    }

    private void onSave() {
        DrawingPacket packet = new DrawingPacket(this.drawingData, this.pageNumber, this.hand == InteractionHand.MAIN_HAND);
        NetworkHandler.sendToServer(packet);
        this.f_96541_.m_91152_(null);
    }

    private void onCancel() {
        this.f_96541_.m_91152_(null);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.onCancel();
    }
}

