/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sketchybooks.data;

public enum ColorPalette {
    WHITE(0xFFFFFF, "color.sketchy_books.white"),
    LIGHT_GRAY(0xAAAAAA, "color.sketchy_books.light_gray"),
    GRAY(0x555555, "color.sketchy_books.gray"),
    BLACK(0, "color.sketchy_books.black"),
    RED(0xFF5555, "color.sketchy_books.red"),
    ORANGE(0xFFAA00, "color.sketchy_books.orange"),
    YELLOW(0xFFFF55, "color.sketchy_books.yellow"),
    LIME(0x55FF55, "color.sketchy_books.lime"),
    GREEN(43520, "color.sketchy_books.green"),
    CYAN(43690, "color.sketchy_books.cyan"),
    LIGHT_BLUE(0x5555FF, "color.sketchy_books.light_blue"),
    BLUE(170, "color.sketchy_books.blue"),
    PURPLE(0xAA00AA, "color.sketchy_books.purple"),
    MAGENTA(0xFF55FF, "color.sketchy_books.magenta"),
    PINK(0xFFAAFF, "color.sketchy_books.pink"),
    BROWN(0xAA5500, "color.sketchy_books.brown");

    private final int rgbValue;
    private final String translationKey;

    private ColorPalette(int rgbValue, String translationKey) {
        this.rgbValue = rgbValue;
        this.translationKey = translationKey;
    }

    public int getRgbValue() {
        return this.rgbValue;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public int getRed() {
        return this.rgbValue >> 16 & 0xFF;
    }

    public int getGreen() {
        return this.rgbValue >> 8 & 0xFF;
    }

    public int getBlue() {
        return this.rgbValue & 0xFF;
    }

    public static ColorPalette fromIndex(int index) {
        if (index < 0 || index >= ColorPalette.values().length) {
            throw new IllegalArgumentException("Index de couleur invalide: " + index + ". Doit \u00eatre entre 0 et " + (ColorPalette.values().length - 1));
        }
        return ColorPalette.values()[index];
    }

    public int getIndex() {
        return this.ordinal();
    }

    public int getMinecraftColor() {
        return 0xFF000000 | this.rgbValue;
    }

    public static ColorPalette fromRgb(int rgb) {
        rgb &= 0xFFFFFF;
        for (ColorPalette color : ColorPalette.values()) {
            if (color.rgbValue != rgb) continue;
            return color;
        }
        ColorPalette closest = WHITE;
        int minDistance = Integer.MAX_VALUE;
        int targetR = rgb >> 16 & 0xFF;
        int targetG = rgb >> 8 & 0xFF;
        int targetB = rgb & 0xFF;
        for (ColorPalette color : ColorPalette.values()) {
            int db;
            int dg;
            int dr = color.getRed() - targetR;
            int distance = dr * dr + (dg = color.getGreen() - targetG) * dg + (db = color.getBlue() - targetB) * db;
            if (distance >= minDistance) continue;
            minDistance = distance;
            closest = color;
        }
        return closest;
    }
}

