/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sketchybooks.data;

import net.mcreator.sketchybooks.data.ColorPalette;
import net.minecraft.nbt.CompoundTag;

public class DrawingData {
    public static final int GRID_SIZE = 16;
    private static final int TOTAL_PIXELS = 256;
    private static final String NBT_PIXELS_KEY = "pixels";
    private final byte[] pixels;

    public DrawingData() {
        this.pixels = new byte[256];
    }

    private DrawingData(byte[] pixels) {
        if (pixels.length != 256) {
            throw new IllegalArgumentException("Le tableau de pixels doit contenir exactement 256 \u00e9l\u00e9ments");
        }
        this.pixels = (byte[])pixels.clone();
    }

    public void setPixel(int x, int y, int colorIndex) {
        this.validateCoordinates(x, y);
        this.validateColorIndex(colorIndex);
        this.pixels[this.getPixelIndex((int)x, (int)y)] = (byte)colorIndex;
    }

    public int getPixel(int x, int y) {
        this.validateCoordinates(x, y);
        return this.pixels[this.getPixelIndex(x, y)] & 0xFF;
    }

    public void clear() {
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = 0;
        }
    }

    public void fill(int colorIndex) {
        this.validateColorIndex(colorIndex);
        byte color = (byte)colorIndex;
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = color;
        }
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128382_(NBT_PIXELS_KEY, this.pixels);
        return tag;
    }

    public static DrawingData fromNBT(CompoundTag tag) {
        if (tag == null || !tag.m_128441_(NBT_PIXELS_KEY)) {
            return new DrawingData();
        }
        byte[] pixelData = tag.m_128463_(NBT_PIXELS_KEY);
        if (pixelData.length != 256) {
            return new DrawingData();
        }
        for (byte pixel : pixelData) {
            int colorIndex = pixel & 0xFF;
            if (colorIndex >= 0 && colorIndex < ColorPalette.values().length) continue;
            return new DrawingData();
        }
        return new DrawingData(pixelData);
    }

    private int getPixelIndex(int x, int y) {
        return y * 16 + x;
    }

    private void validateCoordinates(int x, int y) {
        if (x < 0 || x >= 16 || y < 0 || y >= 16) {
            throw new IndexOutOfBoundsException(String.format("Coordonn\u00e9es hors limites: (%d, %d). Doit \u00eatre entre (0, 0) et (%d, %d)", x, y, 15, 15));
        }
    }

    private void validateColorIndex(int colorIndex) {
        if (colorIndex < 0 || colorIndex >= ColorPalette.values().length) {
            throw new IllegalArgumentException("Index de couleur invalide: " + colorIndex + ". Doit \u00eatre entre 0 et " + (ColorPalette.values().length - 1));
        }
    }

    public DrawingData copy() {
        return new DrawingData(this.pixels);
    }

    public boolean isEmpty() {
        for (byte pixel : this.pixels) {
            if (pixel == 0) continue;
            return false;
        }
        return true;
    }

    public ColorPalette getColor(int x, int y) {
        return ColorPalette.fromIndex(this.getPixel(x, y));
    }

    public void setColor(int x, int y, ColorPalette color) {
        this.setPixel(x, y, color.getIndex());
    }
}

