/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sketchybooks.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import net.mcreator.sketchybooks.client.gui.DrawingScreen;
import net.mcreator.sketchybooks.client.renderer.DrawingRenderer;
import net.mcreator.sketchybooks.data.BookDrawingStorage;
import net.mcreator.sketchybooks.data.DrawingData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BookEditScreen.class})
public abstract class BookEditScreenMixin
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Shadow(remap=false, aliases={"f_98056_"})
    private InteractionHand hand;
    @Shadow(remap=false, aliases={"f_98069_"})
    private int currentPage;
    @Shadow(remap=false, aliases={"f_98067_"})
    private boolean isSigning;
    private Button drawButton;

    protected BookEditScreenMixin(Component component) {
        super(component);
    }

    @Inject(method={"init", "m_7856_"}, at={@At(value="TAIL")}, remap=false)
    private void onInit(CallbackInfo ci) {
        try {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                LOGGER.warn("Impossible d'ajouter le bouton Dessiner: joueur null");
                return;
            }
            ItemStack book = player.m_21120_(this.hand);
            if (!book.m_150930_(Items.f_42614_)) {
                LOGGER.debug("Le livre n'est pas un livre inscriptible, bouton Dessiner non ajout\u00e9");
                return;
            }
            int buttonWidth = 100;
            int buttonHeight = 20;
            int buttonX = this.f_96543_ - buttonWidth - 10;
            int buttonY = 10;
            this.drawButton = (Button)this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.sketchy_books.button.draw"), button -> this.onDrawButtonClicked()).m_252987_(buttonX, buttonY, buttonWidth, buttonHeight).m_253136_());
            LOGGER.info("Bouton 'Dessiner' ajout\u00e9 \u00e0 BookEditScreen \u00e0 la position ({}, {})", (Object)buttonX, (Object)buttonY);
        }
        catch (Exception e) {
            LOGGER.error("Erreur lors de l'ajout du bouton Dessiner", (Throwable)e);
        }
    }

    private void onDrawButtonClicked() {
        try {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                LOGGER.error("Impossible d'ouvrir DrawingScreen: joueur null");
                return;
            }
            ItemStack book = player.m_21120_(this.hand);
            if (!book.m_150930_(Items.f_42614_)) {
                LOGGER.error("Impossible d'ouvrir DrawingScreen: l'item n'est pas un livre inscriptible");
                return;
            }
            DrawingData existingDrawing = BookDrawingStorage.loadDrawing(book, this.currentPage);
            LOGGER.info("Ouverture de DrawingScreen pour la page {} (main: {})", (Object)this.currentPage, (Object)this.hand);
            DrawingScreen drawingScreen = new DrawingScreen(existingDrawing, this.currentPage, this.hand);
            Minecraft.m_91087_().m_91152_((Screen)drawingScreen);
        }
        catch (Exception e) {
            LOGGER.error("Erreur lors de l'ouverture de DrawingScreen", (Throwable)e);
        }
    }

    @Inject(method={"render", "m_86412_"}, at={@At(value="TAIL")}, remap=false)
    private void onRender(PoseStack poseStack, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        try {
            if (this.isSigning) {
                return;
            }
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            ItemStack book = player.m_21120_(this.hand);
            if (!book.m_150930_(Items.f_42614_)) {
                return;
            }
            DrawingData drawing = BookDrawingStorage.loadDrawing(book, this.currentPage);
            if (drawing == null) {
                return;
            }
            int bookX = (this.f_96543_ - 192) / 2;
            int bookY = 2;
            int pixelSize = 6;
            int pageWidth = 114;
            int pageHeight = 128;
            int drawingSize = 16 * pixelSize;
            int drawingX = bookX + 36 + (pageWidth - drawingSize) / 2;
            int drawingY = bookY + 32 + (pageHeight - drawingSize) / 2;
            DrawingRenderer.renderDrawing(poseStack, drawing, drawingX, drawingY, pixelSize);
        }
        catch (Exception e) {
            LOGGER.debug("Erreur lors du rendu du dessin dans BookEditScreen", (Throwable)e);
        }
    }
}

