/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sketchybooks.mixin;

import com.mojang.logging.LogUtils;
import java.util.List;
import net.mcreator.sketchybooks.client.BookSigningHandler;
import net.mcreator.sketchybooks.data.BookDrawingStorage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BookEditScreen.class})
public abstract class BookEditScreenSignMixin {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Shadow(remap=false, aliases={"f_98056_"})
    private InteractionHand hand;
    @Shadow(remap=false, aliases={"f_98070_"})
    private List<String> pages;

    @Inject(method={"saveChanges", "m_98160_"}, at={@At(value="HEAD")}, cancellable=false, remap=false)
    private void onBeforeSavePreserveDrawings(boolean signing, CallbackInfo ci) {
        if (!signing) {
            return;
        }
        try {
            int[] pagesWithDrawings;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            ItemStack book = player.m_21120_(this.hand);
            if (!book.m_150930_(Items.f_42614_)) {
                return;
            }
            for (int pageNum : pagesWithDrawings = BookDrawingStorage.getDrawingPages(book)) {
                String pageText;
                if (pageNum >= this.pages.size() || (pageText = this.pages.get(pageNum)) != null && !pageText.trim().isEmpty()) continue;
                this.pages.set(pageNum, " ");
            }
        }
        catch (Exception e) {
            LOGGER.error("Erreur lors de la pr\u00e9servation des pages avec dessins", (Throwable)e);
        }
    }

    @Inject(method={"saveChanges", "m_98160_"}, at={@At(value="HEAD")}, remap=false)
    private void onSaveChangesBefore(boolean signing, CallbackInfo ci) {
        if (!signing) {
            return;
        }
        try {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                return;
            }
            ItemStack writableBook = player.m_21120_(this.hand);
            if (!writableBook.m_150930_(Items.f_42614_)) {
                return;
            }
            CompoundTag bookTag = writableBook.m_41783_();
            if (bookTag != null && bookTag.m_128441_("SketchyBooks")) {
                CompoundTag drawingsData = bookTag.m_128469_("SketchyBooks").m_6426_();
                BookSigningHandler.savePendingDrawings(drawingsData, this.hand);
            }
        }
        catch (Exception e) {
            LOGGER.error("Erreur lors de la sauvegarde des dessins avant signature", (Throwable)e);
        }
    }
}

