/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.sketchybooks.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import net.mcreator.sketchybooks.client.renderer.DrawingRenderer;
import net.mcreator.sketchybooks.data.BookDrawingStorage;
import net.mcreator.sketchybooks.data.DrawingData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BookViewScreen.class})
public abstract class BookViewScreenMixin
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Shadow(remap=false, aliases={"f_98253_"})
    @Final
    private BookViewScreen.BookAccess bookAccess;
    @Shadow(remap=false, aliases={"f_98254_"})
    private int currentPage;
    private ItemStack realBookStack = ItemStack.f_41583_;

    protected BookViewScreenMixin(Component component) {
        super(component);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")}, remap=false)
    private void onInit(BookViewScreen.BookAccess bookAccess, CallbackInfo ci) {
        this.realBookStack = this.getWrittenBookFromPlayer();
        if (this.realBookStack != null && !this.realBookStack.m_41619_()) {
            LOGGER.info("[SketchyBooks] Livre sign\u00e9 r\u00e9cup\u00e9r\u00e9 depuis les mains du joueur");
            LOGGER.debug("[SketchyBooks] NBT du livre: {}", (Object)this.realBookStack.m_41783_());
        } else {
            LOGGER.warn("[SketchyBooks] Impossible de r\u00e9cup\u00e9rer le livre sign\u00e9");
        }
    }

    @Inject(method={"render", "m_86412_"}, at={@At(value="TAIL")}, remap=false)
    private void onRender(PoseStack poseStack, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        try {
            if (this.realBookStack == null || this.realBookStack.m_41619_()) {
                return;
            }
            DrawingData drawing = BookDrawingStorage.loadDrawing(this.realBookStack, this.currentPage);
            if (drawing == null) {
                return;
            }
            int bookX = (this.f_96543_ - 192) / 2;
            int bookY = 2;
            int pixelSize = 6;
            int pageWidth = 114;
            int pageHeight = 128;
            int drawingSize = 16 * pixelSize;
            int drawingX = bookX + 36 + (pageWidth - drawingSize) / 2;
            int drawingY = bookY + 32 + (pageHeight - drawingSize) / 2;
            DrawingRenderer.renderDrawing(poseStack, drawing, drawingX, drawingY, pixelSize);
        }
        catch (Exception e) {
            LOGGER.debug("Erreur lors du rendu du dessin dans BookViewScreen", (Throwable)e);
        }
    }

    private ItemStack getWrittenBookFromPlayer() {
        try {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player == null) {
                LOGGER.warn("[SketchyBooks] Joueur null lors de l'ouverture du livre");
                return ItemStack.f_41583_;
            }
            ItemStack mainHand = player.m_21205_();
            if (mainHand.m_150930_(Items.f_42615_)) {
                LOGGER.debug("[SketchyBooks] Livre trouv\u00e9 dans la main principale");
                return mainHand;
            }
            ItemStack offHand = player.m_21206_();
            if (offHand.m_150930_(Items.f_42615_)) {
                LOGGER.debug("[SketchyBooks] Livre trouv\u00e9 dans la main secondaire");
                return offHand;
            }
            LOGGER.warn("[SketchyBooks] Aucun livre sign\u00e9 trouv\u00e9 dans les mains du joueur");
        }
        catch (Exception e) {
            LOGGER.error("[SketchyBooks] Erreur lors de la r\u00e9cup\u00e9ration du livre depuis les mains", (Throwable)e);
        }
        return ItemStack.f_41583_;
    }
}

