/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.provihealth.api;

import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.provismet.provihealth.config.resources.EntityOptions;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1299;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;

public abstract class EntityOptionsDatagenProvider
implements class_2405 {
    private final CompletableFuture<class_7225.class_7874> future;
    private final class_7784.class_7489 pathResolver;

    protected EntityOptionsDatagenProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registriesFuture) {
        this.future = registriesFuture;
        this.pathResolver = dataOutput.method_45973(class_7784.class_7490.field_39368, "provihealth/entity");
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        return this.future.thenCompose(wrapperLookup -> {
            EntityOptionsConsumer consumer = new EntityOptionsConsumer((class_7225.class_7874)wrapperLookup);
            this.generate(consumer);
            return CompletableFuture.allOf((CompletableFuture[])consumer.entries.entrySet().stream().map(entry -> {
                Path path = this.pathResolver.method_44107((class_2960)entry.getKey());
                return class_2405.method_10320((class_7403)writer, (JsonElement)((JsonElement)entry.getValue()), (Path)path);
            }).toArray(CompletableFuture[]::new));
        });
    }

    protected abstract void generate(EntityOptionsConsumer var1);

    public String method_10321() {
        return "ProviHealth Entity Options";
    }

    protected static class EntityOptionsConsumer {
        private final Map<class_2960, JsonElement> entries = new HashMap<class_2960, JsonElement>();
        private final class_7225.class_7874 lookup;

        private EntityOptionsConsumer(class_7225.class_7874 lookup) {
            this.lookup = lookup;
        }

        public void add(class_1299<?> type, EntityOptions options) {
            Optional optionalKey = class_7923.field_41177.method_29113(type);
            if (optionalKey.isEmpty()) {
                throw new RuntimeException("Registry key not found for entity type: " + type.toString());
            }
            DataResult json = EntityOptions.CODEC.encodeStart((DynamicOps)this.lookup.method_57093((DynamicOps)JsonOps.INSTANCE), (Object)options);
            this.entries.put(((class_5321)optionalKey.get()).method_29177(), (JsonElement)json.mapError(message -> "Invalid entry for entity type %s: %s".formatted(((class_5321)optionalKey.get()).method_29177().toString(), message)).getOrThrow());
        }
    }
}

