/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.provihealth.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.provismet.lilylib.util.json.JsonBuilder;
import com.provismet.lilylib.util.json.JsonReader;
import com.provismet.provihealth.ProviHealthClient;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalEntityTypeTags;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class Options {
    private static final String FILE = "./config/provihealth.json";
    public static final Vector3f WHITE = class_243.method_24457((int)0xFFFFFF).method_46409();
    public static int maxHealthBarTicks = 40;
    public static List<String> blacklist = List.of("minecraft:armor_stand");
    public static List<String> blacklistHUD = List.of("minecraft:armor_stand");
    public static VisibilityType bosses = VisibilityType.ALWAYS_HIDE;
    public static VisibilityType hostile = VisibilityType.ALWAYS_SHOW;
    public static VisibilityType players = VisibilityType.HIDE_IF_FULL;
    public static VisibilityType others = VisibilityType.HIDE_IF_FULL;
    public static boolean bossesVisibilityOverride = false;
    public static boolean hostileVisibilityOverride = true;
    public static boolean playersVisibilityOverride = true;
    public static boolean othersVisibilityOverride = true;
    public static HUDType bossHUD = HUDType.FULL;
    public static HUDType hostileHUD = HUDType.FULL;
    public static HUDType playerHUD = HUDType.FULL;
    public static HUDType otherHUD = HUDType.FULL;
    public static float hudGlide = 0.5f;
    public static boolean showHudIcon = true;
    public static boolean useCustomHudPortraits = true;
    public static int hudOffsetPercent = 0;
    public static HUDPosition hudPosition = HUDPosition.LEFT;
    public static int hudStartColour = 49408;
    public static int hudEndColour = 0xFF0000;
    public static Vector3f unpackedStartHud = class_243.method_24457((int)hudStartColour).method_46409();
    public static Vector3f unpackedEndHud = class_243.method_24457((int)hudEndColour).method_46409();
    public static boolean hudGradient = false;
    public static boolean hudTitles = true;
    public static boolean hudStatuses = true;
    public static boolean showTextInWorld = true;
    public static float maxRenderDistance = 24.0f;
    public static float worldHealthBarScale = 1.5f;
    public static int worldStartColour = 49408;
    public static int worldEndColour = 0xFF0000;
    public static Vector3f unpackedStartWorld = class_243.method_24457((int)worldStartColour).method_46409();
    public static Vector3f unpackedEndWorld = class_243.method_24457((int)worldEndColour).method_46409();
    public static boolean worldGradient = false;
    public static boolean overrideLabels = false;
    public static boolean worldShadows = true;
    public static float worldOffsetY = 0.0f;
    public static boolean worldTitles = true;
    public static boolean tintBackground = false;
    public static boolean useTeamColours = false;
    public static boolean spawnDamageParticles = true;
    public static boolean spawnHealingParticles = false;
    public static int damageColour = 0xFF0000;
    public static int healingColour = 65280;
    public static Vector3f unpackedDamage = class_243.method_24457((int)damageColour).method_46409();
    public static Vector3f unpackedHealing = class_243.method_24457((int)healingColour).method_46409();
    public static float particleScale = 0.25f;
    public static boolean particleTextShadow = true;
    public static int damageParticleTextColour = -1;
    public static int healingParticleTextColour = -1;
    public static DamageParticleType particleType = DamageParticleType.RISING;
    public static float maxParticleDistance = 16.0f;
    public static float damageAlpha = 1.0f;
    public static float healingAlpha = 1.0f;
    public static SeeThroughText seeThroughTextType = SeeThroughText.STANDARD;
    public static HUDPortraitCompatMode HUDCompat = HUDPortraitCompatMode.STANDARD;

    public static boolean shouldRenderHealthFor(class_1309 livingEntity) {
        if (blacklist.contains(class_1299.method_5890((class_1299)livingEntity.method_5864()).toString())) {
            return false;
        }
        class_1297 target = class_310.method_1551().field_1692;
        if (livingEntity.method_5864().method_20210(ConventionalEntityTypeTags.BOSSES)) {
            if (bossesVisibilityOverride && livingEntity == target) {
                return true;
            }
            return Options.shouldRenderHealthFor(bosses, livingEntity);
        }
        if (livingEntity instanceof class_1588) {
            if (hostileVisibilityOverride && livingEntity == target) {
                return true;
            }
            return Options.shouldRenderHealthFor(hostile, livingEntity);
        }
        if (livingEntity instanceof class_1657) {
            if (playersVisibilityOverride && livingEntity == target) {
                return true;
            }
            return Options.shouldRenderHealthFor(players, livingEntity);
        }
        if (othersVisibilityOverride && livingEntity == target) {
            return true;
        }
        return Options.shouldRenderHealthFor(others, livingEntity);
    }

    public static boolean isBlacklisted(class_1297 entity, @Nullable BarType barType) {
        BarType barType2 = barType;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"WORLD", "HUD"}, (BarType)barType2, n)) {
            default -> throw new MatchException(null, null);
            case -1 -> false;
            case 0 -> blacklist.contains(class_1299.method_5890((class_1299)entity.method_5864()).toString());
            case 1 -> blacklistHUD.contains(class_1299.method_5890((class_1299)entity.method_5864()).toString());
        };
    }

    public static void save() {
        String jsonData = new JsonBuilder().append("hud", new JsonBuilder().append("hudDuration", (Number)maxHealthBarTicks).append("hudIcon", showHudIcon).append("hudPortraits", useCustomHudPortraits).append("hudGlide", (Number)Float.valueOf(hudGlide)).append("hudPosition", hudPosition.name()).append("hudOffsetY", (Number)hudOffsetPercent).append("hudGradient", hudGradient).append("hudStartColour", (Number)hudStartColour).append("hudEndColour", (Number)hudEndColour).append("bossHUD", bossHUD.name()).append("hostileHUD", hostileHUD.name()).append("playerHUD", playerHUD.name()).append("otherHUD", otherHUD.name()).append("hudTitles", hudTitles).append("hudStatusEffects", hudStatuses).appendArray("hudBlacklist", blacklistHUD)).append("world", new JsonBuilder().append("replaceLabels", overrideLabels).append("worldHealthText", showTextInWorld).append("worldTextShadows", worldShadows).append("maxRenderDistance", (Number)Float.valueOf(maxRenderDistance)).append("barScale", (Number)Float.valueOf(worldHealthBarScale)).append("worldOffsetY", (Number)Float.valueOf(worldOffsetY)).append("worldGradient", worldGradient).append("worldStartColour", (Number)worldStartColour).append("worldEndColour", (Number)worldEndColour).append("bossHealth", bosses.name()).append("bossTarget", bossesVisibilityOverride).append("hostileHealth", hostile.name()).append("hostileTarget", hostileVisibilityOverride).append("playerHealth", players.name()).append("playerTarget", playersVisibilityOverride).append("otherHealth", others.name()).append("otherTarget", othersVisibilityOverride).append("worldTitles", worldTitles).append("tintBackground", tintBackground).append("useTeamColours", useTeamColours).appendArray("healthBlacklist", blacklist)).append("particles", new JsonBuilder().append("damageParticles", spawnDamageParticles).append("healingParticles", spawnHealingParticles).append("damageColour", (Number)damageColour).append("damageAlpha", (Number)Float.valueOf(damageAlpha)).append("healingColour", (Number)healingColour).append("healingAlpha", (Number)Float.valueOf(healingAlpha)).append("particleScale", (Number)Float.valueOf(particleScale)).append("particleTextShadow", particleTextShadow).append("damageParticleTextColour", (Number)damageParticleTextColour).append("healingParticleTextColour", (Number)healingParticleTextColour).append("particleType", particleType.name()).append("maxParticleDistance", (Number)Float.valueOf(maxParticleDistance))).append("compatibility", new JsonBuilder().append("topLayerTextType", seeThroughTextType.name()).append("compatHudPaperdoll", HUDCompat.name())).toString();
        try (FileWriter writer = new FileWriter(FILE);){
            writer.write(jsonData);
        }
        catch (IOException e) {
            ProviHealthClient.LOGGER.error("Error whilst saving config: ", (Throwable)e);
        }
    }

    public static void load() {
        try {
            JsonReader jsonReader = JsonReader.file((File)new File(FILE));
            if (jsonReader == null) {
                Options.save();
                return;
            }
            jsonReader.get("hud").map(element -> {
                if (element instanceof JsonObject) {
                    JsonObject jsonObject = (JsonObject)element;
                    return new JsonReader(jsonObject);
                }
                return null;
            }).ifPresent(json -> {
                json.getInteger("hudDuration").ifPresent(val -> {
                    maxHealthBarTicks = val;
                });
                json.getBoolean("hudIcon").ifPresent(val -> {
                    showHudIcon = val;
                });
                json.getBoolean("hudPortraits").ifPresent(val -> {
                    useCustomHudPortraits = val;
                });
                json.getFloat("hudGlide").ifPresent(val -> {
                    hudGlide = val.floatValue();
                });
                json.getString("hudPosition").ifPresent(val -> {
                    hudPosition = HUDPosition.valueOf(val);
                });
                json.getInteger("hudOffsetY").ifPresent(val -> {
                    hudOffsetPercent = val;
                });
                json.getBoolean("hudGradient").ifPresent(val -> {
                    hudGradient = val;
                });
                json.getInteger("hudStartColour").ifPresent(val -> {
                    hudStartColour = val;
                });
                json.getInteger("hudEndColour").ifPresent(val -> {
                    hudEndColour = val;
                });
                json.getString("bossHUD").ifPresent(val -> {
                    bossHUD = HUDType.valueOf(val);
                });
                json.getString("hostileHUD").ifPresent(val -> {
                    hostileHUD = HUDType.valueOf(val);
                });
                json.getString("playerHUD").ifPresent(val -> {
                    playerHUD = HUDType.valueOf(val);
                });
                json.getString("otherHUD").ifPresent(val -> {
                    otherHUD = HUDType.valueOf(val);
                });
                json.getBoolean("hudTitles").ifPresent(val -> {
                    hudTitles = val;
                });
                json.getBoolean("hudStatusEffects").ifPresent(val -> {
                    hudStatuses = val;
                });
                json.getArray("hudBlacklist").ifPresent(val -> {
                    blacklistHUD = val.asList().stream().map(JsonElement::getAsJsonPrimitive).map(JsonPrimitive::getAsString).toList();
                });
            });
            jsonReader.get("world").map(element -> {
                if (element instanceof JsonObject) {
                    JsonObject jsonObject = (JsonObject)element;
                    return new JsonReader(jsonObject);
                }
                return null;
            }).ifPresent(json -> {
                json.getBoolean("replaceLabels").ifPresent(val -> {
                    overrideLabels = val;
                });
                json.getBoolean("worldHealthText").ifPresent(val -> {
                    showTextInWorld = val;
                });
                json.getBoolean("worldTextShadows").ifPresent(val -> {
                    worldShadows = val;
                });
                json.getFloat("maxRenderDistance").ifPresent(val -> {
                    maxRenderDistance = val.floatValue();
                });
                json.getFloat("barScale").ifPresent(val -> {
                    worldHealthBarScale = val.floatValue();
                });
                json.getFloat("worldOffsetY").ifPresent(val -> {
                    worldOffsetY = val.floatValue();
                });
                json.getBoolean("worldGradient").ifPresent(val -> {
                    worldGradient = val;
                });
                json.getInteger("worldStartColour").ifPresent(val -> {
                    worldStartColour = val;
                });
                json.getInteger("worldEndColour").ifPresent(val -> {
                    worldEndColour = val;
                });
                json.getString("bossHealth").ifPresent(val -> {
                    bosses = VisibilityType.valueOf(val);
                });
                json.getBoolean("bossTarget").ifPresent(val -> {
                    bossesVisibilityOverride = val;
                });
                json.getString("hostileHealth").ifPresent(val -> {
                    hostile = VisibilityType.valueOf(val);
                });
                json.getBoolean("hostileTarget").ifPresent(val -> {
                    hostileVisibilityOverride = val;
                });
                json.getString("playerHealth").ifPresent(val -> {
                    players = VisibilityType.valueOf(val);
                });
                json.getBoolean("playerTarget").ifPresent(val -> {
                    playersVisibilityOverride = val;
                });
                json.getString("otherHealth").ifPresent(val -> {
                    others = VisibilityType.valueOf(val);
                });
                json.getBoolean("otherTarget").ifPresent(val -> {
                    othersVisibilityOverride = val;
                });
                json.getBoolean("worldTitles").ifPresent(val -> {
                    worldTitles = val;
                });
                json.getBoolean("tintBackground").ifPresent(val -> {
                    tintBackground = val;
                });
                json.getBoolean("useTeamColours").ifPresent(val -> {
                    useTeamColours = val;
                });
                json.getArray("healthBlacklist").ifPresent(val -> {
                    blacklist = val.asList().stream().map(JsonElement::getAsJsonPrimitive).map(JsonPrimitive::getAsString).toList();
                });
            });
            jsonReader.get("particles").map(element -> {
                if (element instanceof JsonObject) {
                    JsonObject jsonObject = (JsonObject)element;
                    return new JsonReader(jsonObject);
                }
                return null;
            }).ifPresent(json -> {
                json.getBoolean("damageParticles").ifPresent(val -> {
                    spawnDamageParticles = val;
                });
                json.getBoolean("healingParticles").ifPresent(val -> {
                    spawnHealingParticles = val;
                });
                json.getInteger("damageColour").ifPresent(val -> {
                    damageColour = val;
                });
                json.getFloat("damageAlpha").ifPresent(val -> {
                    damageAlpha = val.floatValue();
                });
                json.getInteger("healingColour").ifPresent(val -> {
                    healingColour = val;
                });
                json.getFloat("healingAlpha").ifPresent(val -> {
                    healingAlpha = val.floatValue();
                });
                json.getFloat("particleScale").ifPresent(val -> {
                    particleScale = val.floatValue();
                });
                json.getBoolean("particleTextShadow").ifPresent(val -> {
                    particleTextShadow = val;
                });
                json.getInteger("damageParticleTextColour").ifPresent(val -> {
                    damageParticleTextColour = val;
                });
                json.getInteger("healingParticleTextColour").ifPresent(val -> {
                    healingParticleTextColour = val;
                });
                json.getString("particleType").ifPresent(val -> {
                    particleType = DamageParticleType.valueOf(val);
                });
                json.getFloat("maxParticleDistance").ifPresent(val -> {
                    maxParticleDistance = val.floatValue();
                });
            });
            jsonReader.get("compatibility").map(element -> {
                if (element instanceof JsonObject) {
                    JsonObject jsonObject = (JsonObject)element;
                    return new JsonReader(jsonObject);
                }
                return null;
            }).ifPresent(json -> {
                json.getString("topLayerTextType").ifPresent(val -> {
                    seeThroughTextType = SeeThroughText.valueOf(val);
                });
                json.getString("compatHudPaperdoll").ifPresent(val -> {
                    HUDCompat = HUDPortraitCompatMode.valueOf(val);
                });
            });
            Options.save();
        }
        catch (FileNotFoundException e) {
            ProviHealthClient.LOGGER.info("No config found, creating new one.");
            Options.save();
        }
    }

    private static boolean shouldRenderHealthFor(VisibilityType type, class_1309 livingEntity) {
        return switch (type.ordinal()) {
            case 0 -> false;
            case 1 -> {
                if (livingEntity.method_6032() < livingEntity.method_6063()) {
                    yield true;
                }
                if (livingEntity.method_5765()) {
                    for (class_1297 vehicle = livingEntity.method_5854(); vehicle != null; vehicle = vehicle.method_5854()) {
                        class_1309 livingVehicle;
                        if (!(vehicle instanceof class_1309) || !((livingVehicle = (class_1309)vehicle).method_6032() < livingVehicle.method_6063())) continue;
                        yield true;
                    }
                }
                yield false;
            }
            default -> true;
        };
    }

    public static enum VisibilityType {
        ALWAYS_HIDE,
        HIDE_IF_FULL,
        ALWAYS_SHOW;


        public String toString() {
            return "enum.provihealth." + super.toString().toLowerCase();
        }
    }

    public static enum BarType {
        WORLD,
        HUD;

    }

    public static enum HUDPosition {
        LEFT(150.0f),
        RIGHT(210.0f);

        public final float portraitYAW;

        private HUDPosition(float portraitYAW) {
            this.portraitYAW = portraitYAW;
        }

        public String toString() {
            return "enum.provihealth." + super.toString().toLowerCase();
        }
    }

    public static enum HUDType {
        NONE(false, false, false),
        PORTRAIT_ONLY(true, false, false),
        FULL(true, true, true);

        public final boolean showPortrait;
        public final boolean showBars;
        public final boolean showTitles;

        private HUDType(boolean showPortrait, boolean showBars, boolean showTitles) {
            this.showPortrait = showPortrait;
            this.showBars = showBars;
            this.showTitles = showTitles;
        }

        public String toString() {
            return "enum.provihealth." + super.toString().toLowerCase();
        }
    }

    public static enum DamageParticleType {
        RISING,
        GRAVITY,
        STATIC;


        public String toString() {
            return "enum.provihealth." + super.toString().toLowerCase();
        }
    }

    public static enum SeeThroughText {
        STANDARD,
        NONE,
        FULL;


        public String toString() {
            return "enum.provihealth.seethroughtext." + super.toString().toLowerCase();
        }
    }

    public static enum HUDPortraitCompatMode {
        STANDARD,
        COMPAT,
        NONE;


        public String toString() {
            return "enum.provihealth.hudportraitcompatmode." + super.toString().toLowerCase();
        }
    }
}

