/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.provihealth.hud;

import com.mojang.blaze3d.textures.GpuTextureView;
import com.provismet.provihealth.ProviHealthClient;
import com.provismet.provihealth.config.Options;
import com.provismet.provihealth.config.resources.EntityOptions;
import com.provismet.provihealth.hud.ElementRegistry;
import com.provismet.provihealth.hud.LayeredQuadGuiElementRenderState;
import com.provismet.provihealth.interfaces.IMixinEntityRenderState;
import com.provismet.provihealth.interfaces.IMixinLivingEntity;
import com.provismet.provihealth.util.ColourHelper;
import com.provismet.provihealth.util.HealthCalculator;
import com.provismet.provihealth.util.HealthContainer;
import com.provismet.provihealth.util.Visibility;
import java.util.List;
import java.util.SequencedCollection;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElement;
import net.minecraft.class_10017;
import net.minecraft.class_10799;
import net.minecraft.class_11231;
import net.minecraft.class_11244;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_5348;
import net.minecraft.class_6880;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_9779;
import net.minecraft.class_9848;
import org.joml.Matrix3x2f;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class TargetHealthBar
implements HudElement {
    public static final class_2960 HEALTHBAR_LAYER = ProviHealthClient.identifier("healthbar_layer");
    private static final class_2960 COMPAT_BARS = ProviHealthClient.identifier("textures/gui/healthbars/bars_coloured.png");
    private static final class_2960 HEART = ProviHealthClient.identifier("textures/gui/healthbars/icons/heart.png");
    private static final class_2960 MOUNT_HEART = ProviHealthClient.identifier("textures/gui/healthbars/icons/mount_heart.png");
    private static final class_2960 ARMOUR = ProviHealthClient.identifier("textures/gui/healthbars/icons/armour.png");
    private static int OFFSET_X = 0;
    private static int OFFSET_Y = 0;
    private static final int BAR_WIDTH = 128;
    private static final int BAR_HEIGHT = 10;
    private static final int MOUNT_BAR_HEIGHT = 6;
    private static final int MOUNT_BAR_WIDTH = 121;
    private static final int FRAME_LENGTH = 48;
    private static final int LEFT_TEXT_X = 50;
    private static int BAR_X = 43;
    private static int BAR_Y = OFFSET_Y + 24 - 8;
    private static final int FOREGROUND_Z = 300;
    private static final int BACKGROUND_Z = 0;
    private static int TEXT_BASE_Y = BAR_Y + 10 + 1;
    private static int EFFECT_X = 50;
    private static int EFFECT_BASE_Y = TEXT_BASE_Y + 11;
    private static int EFFECT_X_OFFSET = 17;
    private static final float BAR_V2 = 0.3125f;
    private static final float MOUNT_BAR_U2 = 0.9453125f;
    private static final float MOUNT_BAR_V1 = 0.3125f;
    private static final float MOUNT_BAR_V2 = 0.5f;
    private static final int BAR_WIDTH_DIFF = 7;
    private class_1309 target = null;
    private float healthBarDuration = 0.0f;
    private int currentHealthWidth;
    private int currentVehicleHealthWidth;

    public void render(class_332 drawContext, class_9779 tickCounter) {
        float tickDelta = tickCounter.method_60637(true);
        if (this.healthBarDuration > 0.0f) {
            this.healthBarDuration -= tickDelta;
        } else {
            this.reset();
        }
        if (!class_310.method_1498() || class_310.method_1551().method_53526().method_53536() || class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_7325()) {
            return;
        }
        boolean isNewTarget = false;
        class_1297 class_12972 = class_310.method_1551().field_1692;
        if (class_12972 instanceof class_1309) {
            class_1309 living = (class_1309)class_12972;
            if (!Visibility.isVisible(living)) {
                return;
            }
            if (!living.equals((Object)this.target)) {
                isNewTarget = true;
            }
            this.target = living;
            this.healthBarDuration = Options.maxHealthBarTicks;
        }
        if (this.healthBarDuration <= 0.0f) {
            return;
        }
        if (this.target == null) {
            this.reset();
            return;
        }
        this.adjustForScreenSize();
        EntityOptions entityOptions = ElementRegistry.getEntityOptions(this.target);
        Options.HUDType hudType = entityOptions.getHudType(this.target);
        float healthPercent = class_3532.method_15363((float)(this.target.method_6032() / this.target.method_6063()), (float)0.0f, (float)1.0f);
        HealthContainer mountHealth = HealthCalculator.getRecursiveMountHealth((class_1297)this.target, Options.BarType.HUD);
        float vehicleHealthPercent = mountHealth != null ? mountHealth.getPercentage() : 0.0f;
        int healthWidth = Math.round(128.0f * healthPercent);
        int vehicleHealthWidth = Math.round(121.0f * vehicleHealthPercent);
        if (isNewTarget) {
            this.currentHealthWidth = healthWidth;
            this.currentVehicleHealthWidth = vehicleHealthWidth;
        }
        int nameWidth = class_310.method_1551().field_1772.method_27525((class_5348)this.getName(this.target));
        if (hudType.showBars) {
            List<class_6880<class_1291>> effects;
            class_2960 healthbarTexture = entityOptions.getHealthBar(this.target);
            this.renderBar(drawContext, healthbarTexture, 128, 1);
            this.renderBar(drawContext, healthbarTexture, this.glideHealth(healthWidth, tickDelta * Options.hudGlide), 0);
            if (mountHealth != null) {
                this.renderMountBar(drawContext, healthbarTexture, 121, 1);
                this.renderMountBar(drawContext, healthbarTexture, this.glideVehicleHealth(vehicleHealthWidth, tickDelta * Options.hudGlide), 0);
            }
            int infoLeftX = 50;
            class_1799 icon = entityOptions.getIcon(this.target);
            if (Options.hudPosition == Options.HUDPosition.LEFT) {
                expectedNameX = 50 + nameWidth + 2;
                if (icon != null && Options.showHudIcon) {
                    drawContext.method_51427(icon, Math.max(BAR_X + 128 - 16, expectedNameX), BAR_Y - 16);
                }
            } else {
                expectedNameX = OFFSET_X - 18 - nameWidth;
                if (icon != null && Options.showHudIcon) {
                    drawContext.method_51427(icon, Math.min(BAR_X, expectedNameX), BAR_Y - 16);
                }
                infoLeftX = BAR_X + 3;
            }
            int offsetFromMountBar = mountHealth != null ? 6 : 0;
            int healthX = this.drawTextAndGetWidth(drawContext, String.format("%d/%d", Math.round(this.target.method_6032()), Math.round(this.target.method_6063())), infoLeftX, TEXT_BASE_Y + 1 + offsetFromMountBar, 0xFFFFFF, true);
            drawContext.method_25302(class_10799.field_56883, HEART, healthX, TEXT_BASE_Y + offsetFromMountBar, 0.0f, 0.0f, 9, 9, 9, 9, 9, 9);
            int armourX = class_310.method_1551().field_1772.method_1727(String.format("%d/%d", Math.round(this.target.method_6063()), Math.round(this.target.method_6063()))) + infoLeftX + 18;
            if (this.target.method_6096() > 0) {
                armourX = this.drawTextAndGetWidth(drawContext, String.format("%d", this.target.method_6096()), armourX, TEXT_BASE_Y + 1 + offsetFromMountBar, 0xFFFFFF, true);
                drawContext.method_25302(class_10799.field_56883, ARMOUR, armourX, TEXT_BASE_Y + offsetFromMountBar, 0.0f, 0.0f, 9, 9, 9, 9, 9, 9);
            }
            if (mountHealth != null) {
                String mountHealthString = String.format("%d/%d", Math.round(mountHealth.getCurrent()), Math.round(mountHealth.getMax()));
                int mountHealthWidth = class_310.method_1551().field_1772.method_1727(mountHealthString) + 9;
                int expectedLeftPixel = BAR_X + 128 - mountHealthWidth - 3;
                if (expectedLeftPixel < armourX) {
                    expectedLeftPixel = armourX + 10;
                }
                int mountHealthX = this.drawTextAndGetWidth(drawContext, mountHealthString, expectedLeftPixel, TEXT_BASE_Y + 1 + 6, 0xFFFFFF, true);
                drawContext.method_25302(class_10799.field_56883, MOUNT_HEART, mountHealthX, TEXT_BASE_Y + 6, 0.0f, 0.0f, 9, 9, 9, 9, 9, 9);
            }
            if (Options.hudStatuses && !(effects = ((IMixinLivingEntity)this.target).provi_Health$getClientSideStatusEffects()).isEmpty()) {
                int effectXOffset = 0;
                for (class_6880<class_1291> effect : effects) {
                    class_2960 effectTexture = class_329.method_71644(effect);
                    drawContext.method_52706(class_10799.field_56883, effectTexture, EFFECT_X + effectXOffset, EFFECT_BASE_Y + offsetFromMountBar, 16, 16);
                    effectXOffset += EFFECT_X_OFFSET;
                }
            }
        }
        if (Options.hudTitles && hudType.showTitles) {
            SequencedCollection titles = ElementRegistry.getTitle(this.target, false, true).reversed();
            int titleX = 5;
            int titleY = OFFSET_Y + 48 + 5;
            if (Options.hudPosition == Options.HUDPosition.LEFT) {
                for (class_2561 title : titles) {
                    drawContext.method_51439(class_310.method_1551().field_1772, title, titleX, titleY, -1, true);
                    titleY += 10;
                }
            } else {
                for (class_2561 title : titles) {
                    titleX = class_310.method_1551().method_22683().method_4486() - 10 - class_310.method_1551().field_1772.method_27525((class_5348)title);
                    drawContext.method_51439(class_310.method_1551().field_1772, title, titleX, titleY, -1, true);
                    titleY += 10;
                }
            }
        }
        if (hudType.showPortrait) {
            if (Options.hudPosition == Options.HUDPosition.LEFT) {
                this.drawTexturedQuad(entityOptions.getBorder(this.target), drawContext, 0, OFFSET_Y, 0, 48.0f, 0.0f, 48, 48, 96, 48);
                this.drawTexturedQuad(entityOptions.getBorder(this.target), drawContext, 0, OFFSET_Y, 300, 0.0f, 0.0f, 48, 48, 96, 48);
                drawContext.method_51439(class_310.method_1551().field_1772, this.getName(this.target), 50, BAR_Y - 10, -1, true);
            } else {
                this.drawHorizontallyMirroredTexturedQuad(entityOptions.getBorder(this.target), drawContext, OFFSET_X, OFFSET_X + 48, OFFSET_Y, OFFSET_Y + 48, 0, 0.5f, 1.0f, 0.0f, 1.0f, -1);
                this.drawHorizontallyMirroredTexturedQuad(entityOptions.getBorder(this.target), drawContext, OFFSET_X, OFFSET_X + 48, OFFSET_Y, OFFSET_Y + 48, 300, 0.0f, 0.5f, 0.0f, 1.0f, -1);
                drawContext.method_51439(class_310.method_1551().field_1772, this.getName(this.target), OFFSET_X - 1 - nameWidth, BAR_Y - 10, -1, true);
            }
            if (Options.HUDCompat == Options.HUDPortraitCompatMode.STANDARD) {
                float prevTargetHeadYaw = this.target.field_6241;
                float prevPrevTargetHeadYaw = this.target.field_6259;
                float prevTargetBodyYaw = this.target.field_6283;
                float prevPrevTargetBodyYaw = this.target.field_6220;
                this.target.field_6283 = Options.hudPosition.portraitYAW;
                this.target.field_6220 = Options.hudPosition.portraitYAW;
                this.target.field_6241 = Options.hudPosition.portraitYAW;
                this.target.field_6259 = Options.hudPosition.portraitYAW;
                this.drawEntity(drawContext, new Quaternionf().rotateZ((float)Math.PI));
                this.target.field_6241 = prevTargetHeadYaw;
                this.target.field_6259 = prevPrevTargetHeadYaw;
                this.target.field_6283 = prevTargetBodyYaw;
                this.target.field_6220 = prevPrevTargetBodyYaw;
            } else if (Options.HUDCompat == Options.HUDPortraitCompatMode.COMPAT) {
                float yawOffset = -(Options.hudPosition.portraitYAW - this.target.method_43078()) / 57.295776f;
                this.drawEntity(drawContext, new Quaternionf().rotateZ((float)Math.PI).rotateY(yawOffset));
            }
        }
    }

    private class_2561 getName(class_1309 entity) {
        if (entity instanceof class_1657 && entity.method_5756((class_1657)class_310.method_1551().field_1724)) {
            return class_2561.method_43471((String)"entity.provihealth.unknownPlayer");
        }
        return entity.method_5476();
    }

    private int glideHealth(int trueValue, float glideFactor) {
        this.currentHealthWidth += (int)((float)(trueValue - this.currentHealthWidth) * class_3532.method_15363((float)glideFactor, (float)0.001f, (float)1.0f));
        return this.currentHealthWidth;
    }

    private int glideVehicleHealth(int trueValue, float glideFactor) {
        this.currentVehicleHealthWidth += (int)((float)(trueValue - this.currentVehicleHealthWidth) * class_3532.method_15363((float)glideFactor, (float)0.001f, (float)1.0f));
        return this.currentVehicleHealthWidth;
    }

    private void renderBar(class_332 drawContext, class_2960 texture, int width, int barIndex) {
        int barColour = ColourHelper.lerpBarColour((float)width / 128.0f, barIndex == 1 ? -1 : Options.hudStartColour, Options.hudEndColour, barIndex == 0 && Options.hudGradient);
        if (Options.hudPosition == Options.HUDPosition.LEFT) {
            drawContext.method_25295(class_10799.field_56883, texture, BAR_X, BAR_X + width, BAR_Y, BAR_Y + 10, 0.0f, (float)width / 128.0f, (float)barIndex / 2.0f, 0.3125f + (float)barIndex / 2.0f, barColour);
        } else {
            this.drawHorizontallyMirroredTexturedQuad(texture, drawContext, BAR_X + (128 - width), BAR_X + 128, BAR_Y, BAR_Y + 10, 0, 0.0f, (float)width / 128.0f, (float)barIndex / 2.0f, 0.3125f + (float)barIndex / 2.0f, barColour);
        }
    }

    private void renderMountBar(class_332 drawContext, class_2960 texture, int width, int barIndex) {
        int barColour = ColourHelper.lerpBarColour((float)width / 121.0f, barIndex == 1 ? -1 : Options.hudStartColour, Options.hudEndColour, barIndex == 0 && Options.hudGradient);
        if (Options.hudPosition == Options.HUDPosition.LEFT) {
            drawContext.method_25295(class_10799.field_56883, texture, BAR_X, BAR_X + width, BAR_Y + 10, BAR_Y + 10 + 6, 0.0f, (float)width / 121.0f * 0.9453125f, 0.3125f + (float)barIndex / 2.0f, 0.5f + (float)barIndex / 2.0f, barColour);
        } else {
            this.drawHorizontallyMirroredTexturedQuad(texture, drawContext, BAR_X + (121 - width) + 7, BAR_X + 7 + 121, BAR_Y + 10, BAR_Y + 10 + 6, 0, 0.0f, (float)width / 121.0f * 0.9453125f, 0.3125f + (float)barIndex / 2.0f, 0.5f + (float)barIndex / 2.0f, barColour);
        }
    }

    private void reset() {
        this.healthBarDuration = 0.0f;
        this.target = null;
        this.currentHealthWidth = 0;
        this.currentVehicleHealthWidth = 0;
    }

    private void adjustForScreenSize() {
        OFFSET_Y = Math.min((int)((float)class_310.method_1551().method_22683().method_4502() * ((float)Options.hudOffsetPercent / 100.0f)), class_310.method_1551().method_22683().method_4502() - 48);
        BAR_Y = OFFSET_Y + 24 - 8;
        TEXT_BASE_Y = BAR_Y + 10 + 1;
        EFFECT_BASE_Y = TEXT_BASE_Y + 11;
        if (Options.hudPosition == Options.HUDPosition.LEFT) {
            OFFSET_X = 0;
            BAR_X = 43;
            EFFECT_X = 50;
            EFFECT_X_OFFSET = 17;
        } else {
            int width = class_310.method_1551().method_22683().method_4486();
            OFFSET_X = width - 48;
            BAR_X = OFFSET_X + 5 - 128;
            EFFECT_X = OFFSET_X - 18;
            EFFECT_X_OFFSET = -17;
        }
    }

    private void drawHorizontallyMirroredTexturedQuad(class_2960 texture, class_332 context, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2, int colour) {
        this.drawTexturedZQuad(texture, context, x1, x2, y1, y2, z, u2, u1, v1, v2, class_9848.method_64963((int)colour));
    }

    private void drawTexturedQuad(class_2960 texture, class_332 context, int x, int y, int z, float u, float v, int width, int height, int textureWidth, int textureHeight) {
        this.drawTexturedZQuad(texture, context, x, x + width, y, y + height, z, u / (float)textureWidth, (u + (float)width) / (float)textureWidth, v / (float)textureHeight, (v + (float)height) / (float)textureHeight, Options.WHITE);
    }

    private void drawTexturedZQuad(class_2960 texture, class_332 context, int x1, int x2, int y1, int y2, int z, float u1, float u2, float v1, float v2, Vector3f colour) {
        context.field_59826.method_70919((class_11244)new LayeredQuadGuiElementRenderState(class_10799.field_56883, class_11231.method_70900((GpuTextureView)class_310.method_1551().method_1531().method_4619(texture).method_71659()), (Matrix3x2f)context.method_51448(), x1, y1, x2, y2, z, u1, u2, v1, v2, colour, context.field_44659.method_70863()));
    }

    private int drawTextAndGetWidth(class_332 context, String text, int x, int y, int colour, boolean shadow) {
        context.method_51433(class_310.method_1551().field_1772, text, x, y, class_9848.method_61334((int)colour), shadow);
        return x + class_310.method_1551().field_1772.method_1727(text);
    }

    private void drawEntity(class_332 context, Quaternionf rotation) {
        float renderHeight;
        if ((double)this.target.method_18381(class_4050.field_18076) >= (double)this.target.method_17682() * 0.6) {
            renderHeight = this.target.method_18381(this.target.method_18376()) + 0.5f;
            if (renderHeight < 1.0f) {
                renderHeight = 1.0f;
            }
        } else {
            renderHeight = this.target.method_18381(this.target.method_18376()) + 0.8f;
        }
        context.method_44379(OFFSET_X, OFFSET_Y, OFFSET_X + 48, OFFSET_Y + 48);
        this.drawEntity(context, OFFSET_X, OFFSET_Y - 50, OFFSET_X + 48, OFFSET_Y + 48, 30.0f, new Vector3f(0.0f, renderHeight, 0.0f), rotation, this.target);
        context.method_44380();
    }

    private void drawEntity(class_332 drawer, int x1, int y1, int x2, int y2, float scale, Vector3f translation, Quaternionf rotation, class_1309 entity) {
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        class_897 entityRenderer = entityRenderDispatcher.method_3953((class_1297)entity);
        class_10017 state = entityRenderer.method_62425((class_1297)entity, 1.0f);
        state.field_58169 = null;
        state.field_53335 = false;
        state.field_53338 = null;
        ((IMixinEntityRenderState)state).provi_Health$setShouldRenderHealth(false);
        drawer.method_70856(state, scale, translation, rotation, null, x1, y1, x2, y2);
    }
}

