/*
 * Decompiled with CFR 0.152.
 */
package com.provismet.provihealth.mixin;

import com.provismet.provihealth.config.Options;
import com.provismet.provihealth.interfaces.IMixinLivingEntity;
import com.provismet.provihealth.particle.HealthParticleEffect;
import com.provismet.provihealth.util.HealthCalculator;
import com.provismet.provihealth.util.HealthContainer;
import com.provismet.provihealth.util.StatusEffectIdentifier;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2940;
import net.minecraft.class_310;
import net.minecraft.class_6880;
import net.minecraft.class_9381;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements IMixinLivingEntity {
    @Unique
    private HealthContainer container;
    @Unique
    private HealthContainer mountContainer;
    @Shadow
    @Final
    private static class_2940<List<class_2394>> field_49792;

    protected LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Shadow
    public abstract float method_6032();

    @Shadow
    public abstract float method_6063();

    @Override
    public HealthContainer provi_Health$getHealthContainer() {
        return this.container;
    }

    @Override
    public HealthContainer provi_Health$getMountHealthContainer() {
        return this.mountContainer;
    }

    @Override
    public List<class_6880<class_1291>> provi_Health$getClientSideStatusEffects() {
        List particles = (List)this.field_6011.method_12789(field_49792);
        if (particles.isEmpty()) {
            return List.of();
        }
        return particles.stream().filter(particle -> particle instanceof class_9381).map(particle -> StatusEffectIdentifier.fromParticleEffect((class_9381)particle)).distinct().filter(Objects::nonNull).sorted(Comparator.comparing(effect -> ((class_1291)effect.comp_349()).method_5560().getString())).sorted(Comparator.comparingInt(effect -> ((class_1291)effect.comp_349()).method_18792().ordinal())).toList();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void spawnParticles(CallbackInfo info) {
        if (this.container == null) {
            this.container = new HealthContainer(this.method_6032());
        }
        this.container.set(this.method_6032());
        this.container.setMaxHealth(this.method_6063());
        HealthContainer currentMountHealth = HealthCalculator.getRecursiveMountHealth(this, Options.BarType.WORLD);
        if (this.mountContainer == null || currentMountHealth == null) {
            this.mountContainer = currentMountHealth;
        } else {
            this.mountContainer.setFrom(currentMountHealth);
        }
        class_1297 cameraEntity = class_310.method_1551().method_1560();
        if (cameraEntity != null && this != cameraEntity && this.method_5739(class_310.method_1551().method_1560()) <= Options.maxParticleDistance) {
            if (this.container.getCurrent() < this.container.getPrevious() && Options.spawnDamageParticles) {
                this.method_37908().method_8406((class_2394)new HealthParticleEffect(Options.unpackedDamage, Options.damageAlpha, Options.particleScale, Options.damageParticleTextColour, String.format("%d", (int)this.container.getPrevious() - (int)this.container.getCurrent())), this.method_23317(), this.method_23320(), this.method_23321(), 0.0, 0.0, 0.0);
            } else if (this.container.getCurrent() > this.container.getPrevious() && Options.spawnHealingParticles) {
                this.method_37908().method_8406((class_2394)new HealthParticleEffect(Options.unpackedHealing, Options.healingAlpha, Options.particleScale, Options.healingParticleTextColour, String.format("%d", (int)this.container.getCurrent() - (int)this.container.getPrevious())), this.method_23317(), this.method_23320(), this.method_23321(), 0.0, 0.0, 0.0);
            }
        }
    }
}

