/*
 * Decompiled with CFR 0.152.
 */
package divinerpg;

import divinerpg.compat.ModCompat;
import divinerpg.config.ClientConfig;
import divinerpg.config.CommonConfig;
import divinerpg.events.BossBarRenderer;
import divinerpg.events.ClientSidedExtraEvents;
import divinerpg.events.EventClientLogin;
import divinerpg.events.SpawnEvents;
import divinerpg.events.Ticker;
import divinerpg.events.Tooltips;
import divinerpg.events.enchant.RiveHandler;
import divinerpg.network.Payloads;
import divinerpg.registries.ArmorMaterialRegistry;
import divinerpg.registries.AttachmentRegistry;
import divinerpg.registries.BlockEntityRegistry;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.CreativeTabRegistry;
import divinerpg.registries.DamageRegistry;
import divinerpg.registries.DataComponentRegistry;
import divinerpg.registries.EntityRegistry;
import divinerpg.registries.EventRegistry;
import divinerpg.registries.FeatureRegistry;
import divinerpg.registries.FluidRegistry;
import divinerpg.registries.ItemPropertyRegistry;
import divinerpg.registries.ItemRegistry;
import divinerpg.registries.LootModifierRegistry;
import divinerpg.registries.MenuTypeRegistry;
import divinerpg.registries.MobEffectRegistry;
import divinerpg.registries.ModelPropRegistry;
import divinerpg.registries.PaintingRegistry;
import divinerpg.registries.ParticleRegistry;
import divinerpg.registries.PlacementModifierRegistry;
import divinerpg.registries.PotionRegistry;
import divinerpg.registries.RecipeRegistry;
import divinerpg.registries.SoundRegistry;
import divinerpg.registries.StructureRegistry;
import divinerpg.util.Utils;
import divinerpg.util.vanilla.LogStripper;
import divinerpg.util.vanilla.PlantPots;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="divinerpg")
public class DivineRPG {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "divinerpg";

    public DivineRPG(IEventBus bus, ModContainer container) {
        BlockRegistry.BLOCKS.register(bus);
        DataComponentRegistry.DATA_COMPONENTS.register(bus);
        ItemRegistry.ITEMS.register(bus);
        BlockRegistry.BLOCK_ITEMS.register(bus);
        BlockEntityRegistry.BLOCK_ENTITIES.register(bus);
        FluidRegistry.FLUIDS.register(bus);
        FluidRegistry.FLUID_TYPES.register(bus);
        MenuTypeRegistry.MENU_TYPE.register(bus);
        EntityRegistry.ENTITIES.register(bus);
        ParticleRegistry.PARTICLES.register(bus);
        RecipeRegistry.Serializers.SERIALIZER.register(bus);
        SoundRegistry.SOUNDS.register(bus);
        SoundRegistry.SONGS.register(bus);
        DamageRegistry.DAMAGE_TYPE.register(bus);
        MobEffectRegistry.EFFECTS.register(bus);
        PotionRegistry.POTIONS.register(bus);
        RecipeRegistry.Types.RECIPE_TYPES.register(bus);
        FeatureRegistry.FEATURES.register(bus);
        StructureRegistry.STRUCTURE_TYPE.register(bus);
        PaintingRegistry.PAINTING_VARIANTS.register(bus);
        LootModifierRegistry.GLOBAL_LOOT_MODIFIERS.register(bus);
        CreativeTabRegistry.CREATIVE_MODE_TABS.register(bus);
        ArmorMaterialRegistry.ARMOR_MATERIALS.register(bus);
        AttachmentRegistry.ATTACHMENT_TYPES.register(bus);
        PlacementModifierRegistry.PLACEMENT_MODIFIER.register(bus);
        PlacementModifierRegistry.DENSITY_FUNCTION.register(bus);
        EventRegistry.init();
        NeoForge.EVENT_BUS.addListener(SpawnEvents::spawnPlacementCheck);
        bus.addListener(this::setup);
        bus.addListener(this::post);
        bus.addListener(this::client);
        bus.addListener(SpawnEvents::registerSpawnPlacements);
        bus.addListener(CreativeTabRegistry::creativeTab);
        bus.register(Payloads.class);
        bus.register(EntityRegistry.class);
        bus.register(MenuTypeRegistry.class);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.SPEC, "divinerpg/common.toml");
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC, "divinerpg/client.toml");
    }

    private void setup(FMLCommonSetupEvent event) {
        ModCompat.initCommon(event);
        NeoForge.EVENT_BUS.register((Object)new RiveHandler());
        NeoForge.EVENT_BUS.register((Object)new Ticker());
        NeoForge.EVENT_BUS.register((Object)new RecipeRegistry());
        event.enqueueWork(() -> {
            LogStripper.setup(event);
            PlantPots.setup(event);
            ItemRegistry.registerDispenserItems();
        });
    }

    private void client(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ModelPropRegistry.init();
            BlockEntityRegistry.renderTiles();
            NeoForge.EVENT_BUS.register((Object)new BossBarRenderer());
            NeoForge.EVENT_BUS.register((Object)new EventClientLogin());
            NeoForge.EVENT_BUS.register((Object)new ClientSidedExtraEvents.MusicEvent());
            NeoForge.EVENT_BUS.register((Object)new Tooltips());
            Utils.loadHatInformation();
            ItemPropertyRegistry.registerProperties();
        });
    }

    private void post(FMLLoadCompleteEvent event) {
    }
}

