/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.attachments;

import divinerpg.compat.CuriosCompat;
import divinerpg.registries.AttachmentRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class DimensionalInventory
implements INBTSerializable<CompoundTag> {
    ListTag overworldInventory = new ListTag();
    ListTag overworldCurios = new ListTag();
    ListTag vetheaInventory = new ListTag();
    ListTag vetheaCurios = new ListTag();

    public void transferTo(DimensionalInventory target) {
        target.overworldInventory = this.overworldInventory;
        target.overworldCurios = this.overworldCurios;
        target.vetheaInventory = this.vetheaInventory;
        target.vetheaCurios = this.vetheaCurios;
    }

    public void saveInventory(Player player, String inv) {
        if (inv == "drpg_dream_inventory") {
            this.vetheaInventory = player.getInventory().save(new ListTag());
            if (ModList.get().isLoaded("curios")) {
                this.vetheaCurios = CuriosCompat.saveInventory(player);
            }
        } else {
            this.overworldInventory = player.getInventory().save(new ListTag());
            if (ModList.get().isLoaded("curios")) {
                this.overworldCurios = CuriosCompat.saveInventory(player);
            }
        }
        AttachmentRegistry.DIMENSIONAL_INVENTORY.set((Entity)player, this);
    }

    public void loadInventory(Player player, String inv) {
        if (inv == "drpg_dream_inventory") {
            if (ModList.get().isLoaded("curios")) {
                CuriosCompat.loadInventory(this.vetheaCurios, player);
            }
            player.getInventory().clearContent();
            player.getInventory().load(this.vetheaInventory);
        } else {
            if (ModList.get().isLoaded("curios")) {
                CuriosCompat.loadInventory(this.overworldCurios, player);
            }
            player.getInventory().clearContent();
            player.getInventory().load(this.overworldInventory);
        }
        player.inventoryMenu.broadcastChanges();
    }

    public void clearInventory(String inv) {
        if (inv == "drpg_dream_inventory") {
            this.vetheaInventory = new ListTag();
            if (ModList.get().isLoaded("curios")) {
                this.vetheaCurios = new ListTag();
            }
        } else {
            this.overworldInventory = new ListTag();
            if (ModList.get().isLoaded("curios")) {
                this.overworldCurios = new ListTag();
            }
        }
    }

    public void stateVetheanInventory() {
        System.err.println("Current Vethea Inventory: " + String.valueOf(this.vetheaInventory));
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        if (ModList.get().isLoaded("curios")) {
            tag.put("vethea_curios", (Tag)this.vetheaCurios);
            tag.put("overworld_curios", (Tag)this.overworldCurios);
        }
        tag.put("overworld_inventory", (Tag)this.overworldInventory);
        tag.put("vethea_inventory", (Tag)this.vetheaInventory);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        if (ModList.get().isLoaded("curios") && tag.contains("vethea_curios")) {
            this.vetheaCurios = tag.getList("vethea_curios", 10);
            this.overworldCurios = tag.getList("overworld_curios", 10);
        }
        this.overworldInventory = tag.getList("overworld_inventory", 10);
        this.vetheaInventory = tag.getList("vethea_inventory", 10);
    }
}

