/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.block_entities.block;

import divinerpg.registries.BlockEntityRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class InserterBlockEntity
extends BlockEntity
implements Hopper {
    private ItemStack stack = ItemStack.EMPTY;
    protected int cooldown = 6;
    protected Direction facing = Direction.NORTH;

    public InserterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.INSERTER.get(), pos, state);
        this.facing = (Direction)state.getValue((Property)BlockStateProperties.FACING);
    }

    protected InserterBlockEntity(BlockEntityType<? extends InserterBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void setBlockState(BlockState blockState) {
        super.setBlockState(blockState);
        this.facing = (Direction)blockState.getValue((Property)BlockStateProperties.FACING);
    }

    protected void oldSetBlockState(BlockState state) {
        super.setBlockState(state);
    }

    public boolean isGridAligned() {
        return false;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, InserterBlockEntity block) {
        if (!block.isEmpty() && ((Boolean)state.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            if (block.cooldown < 1) {
                if (InserterBlockEntity.ejectItems(level, pos, block, block.facing)) {
                    block.cooldown = 6;
                }
            } else {
                --block.cooldown;
            }
        }
    }

    public static boolean ejectItems(Level level, BlockPos pos, Hopper blockEntity, Direction facing) {
        if (InserterBlockEntity.insertHook(level, pos, facing, blockEntity)) {
            return true;
        }
        Container container = InserterBlockEntity.getAttachedContainer(level, pos, facing);
        if (container == null) {
            return false;
        }
        Direction direction = facing.getOpposite();
        if (InserterBlockEntity.isFullContainer(container, direction)) {
            return false;
        }
        ItemStack itemstack = blockEntity.getItem(0);
        if (!itemstack.isEmpty()) {
            int j = itemstack.getCount();
            ItemStack itemstack1 = HopperBlockEntity.addItem((Container)blockEntity, (Container)container, (ItemStack)blockEntity.removeItem(0, 1), (Direction)direction);
            if (itemstack1.isEmpty()) {
                container.setChanged();
                return true;
            }
            itemstack.setCount(j);
            if (j == 1) {
                blockEntity.setItem(0, itemstack);
            }
        }
        return false;
    }

    public static Container getAttachedContainer(Level level, BlockPos pos, Direction facing) {
        return HopperBlockEntity.getContainerAt((Level)level, (BlockPos)pos.relative(facing));
    }

    static boolean insertHook(Level level, BlockPos pos, Direction facing, Hopper hopper) {
        return InserterBlockEntity.getAttachedItemHandler(level, pos, facing).map(destinationResult -> {
            IItemHandler itemHandler = (IItemHandler)destinationResult.getKey();
            if (InserterBlockEntity.isFull(itemHandler)) {
                return false;
            }
            if (!hopper.getItem(0).isEmpty()) {
                ItemStack originalSlotContents = hopper.getItem(0).copy();
                ItemStack insertStack = hopper.removeItem(0, 1);
                ItemStack remainder = InserterBlockEntity.putStackInInventoryAllSlots(itemHandler, insertStack);
                if (remainder.isEmpty()) {
                    return true;
                }
                hopper.setItem(0, originalSlotContents);
            }
            return false;
        }).orElse(false);
    }

    public static ItemStack putStackInInventoryAllSlots(IItemHandler destInventory, ItemStack stack) {
        for (int slot = 0; slot < destInventory.getSlots() && !stack.isEmpty(); ++slot) {
            stack = InserterBlockEntity.insertStack(destInventory, stack, slot);
        }
        return stack;
    }

    static ItemStack insertStack(IItemHandler destInventory, ItemStack stack, int slot) {
        ItemStack itemstack = destInventory.getStackInSlot(slot);
        if (destInventory.insertItem(slot, stack, true).isEmpty()) {
            if (itemstack.isEmpty()) {
                destInventory.insertItem(slot, stack, false);
                stack = ItemStack.EMPTY;
            } else if (ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)stack)) {
                stack = destInventory.insertItem(slot, stack, false);
            }
        }
        return stack;
    }

    public static boolean isFull(IItemHandler itemHandler) {
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stackInSlot = itemHandler.getStackInSlot(slot);
            if (!stackInSlot.isEmpty() && stackInSlot.getCount() >= itemHandler.getSlotLimit(slot)) continue;
            return false;
        }
        return true;
    }

    public static Optional<Pair<IItemHandler, Object>> getAttachedItemHandler(Level level, BlockPos pos, Direction direction) {
        return InserterBlockEntity.getItemHandlerAt(level, (double)(pos.getX() + direction.getStepX()) + 0.5, (double)(pos.getY() + direction.getStepY()) + 0.5, (double)(pos.getZ() + direction.getStepZ()) + 0.5, direction.getOpposite());
    }

    static Optional<Pair<IItemHandler, Object>> getItemHandlerAt(Level worldIn, double x, double y, double z, Direction side) {
        BlockPos blockpos;
        BlockState state;
        BlockEntity blockEntity = (state = worldIn.getBlockState(blockpos = BlockPos.containing((double)x, (double)y, (double)z))).hasBlockEntity() ? worldIn.getBlockEntity(blockpos) : null;
        IItemHandler blockCap = (IItemHandler)worldIn.getCapability(Capabilities.ItemHandler.BLOCK, blockpos, state, blockEntity, (Object)side);
        if (blockCap != null) {
            return Optional.of(ImmutablePair.of((Object)blockCap, (Object)blockEntity));
        }
        List list = worldIn.getEntities((Entity)null, new AABB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 0.5, z + 0.5), EntitySelector.ENTITY_STILL_ALIVE);
        if (!list.isEmpty()) {
            Collections.shuffle(list);
            for (Entity entity : list) {
                IItemHandler entityCap = (IItemHandler)entity.getCapability(Capabilities.ItemHandler.ENTITY_AUTOMATION, (Object)side);
                if (entityCap == null) continue;
                return Optional.of(ImmutablePair.of((Object)entityCap, (Object)entity));
            }
        }
        return Optional.empty();
    }

    public static boolean isFullContainer(Container container, Direction direction) {
        if (container instanceof WorldlyContainer) {
            int[] aint;
            WorldlyContainer worldlycontainer = (WorldlyContainer)container;
            for (int i : aint = worldlycontainer.getSlotsForFace(direction)) {
                ItemStack itemstack = container.getItem(i);
                if (itemstack.getCount() >= itemstack.getMaxStackSize()) continue;
                return false;
            }
        } else {
            for (int i = 0; i < container.getContainerSize(); ++i) {
                ItemStack itemstack = container.getItem(i);
                if (itemstack.getCount() >= itemstack.getMaxStackSize()) continue;
                return false;
            }
        }
        return true;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.stack != null && !this.stack.isEmpty()) {
            tag.put("item", this.getItem().save(registries));
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("item")) {
            this.stack = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound("item"));
        }
    }

    public int getContainerSize() {
        return 1;
    }

    public void clearContent() {
        this.stack = ItemStack.EMPTY;
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    protected ItemStack getItem() {
        return this.stack;
    }

    protected ItemStack removeItem(int amount) {
        if (amount <= 0) {
            return ItemStack.EMPTY;
        }
        this.setChanged();
        int c = this.stack.getCount();
        if (amount > c) {
            ItemStack s = this.stack;
            this.stack = ItemStack.EMPTY;
            return s;
        }
        ItemStack s = this.stack.copyWithCount(amount);
        this.stack.setCount(this.stack.getCount() - amount);
        return s;
    }

    public ItemStack getItem(int i) {
        return this.stack;
    }

    public ItemStack removeItem(int i, int amount) {
        return this.removeItem(amount);
    }

    public ItemStack removeItemNoUpdate(int i) {
        ItemStack s = this.stack;
        this.stack = ItemStack.EMPTY;
        return s;
    }

    protected void setItem(ItemStack s) {
        this.stack = s == null ? ItemStack.EMPTY : s;
    }

    public void setItem(int i, ItemStack s) {
        this.setItem(s);
    }

    public boolean stillValid(Player player) {
        return !player.isSpectator();
    }

    public void setRemoved() {
        super.setRemoved();
        this.stack = ItemStack.EMPTY;
    }

    public int countItem(Item i) {
        return this.stack.is(i) ? this.stack.getCount() : 0;
    }

    public boolean hasAnyMatching(Predicate<ItemStack> predicate) {
        return predicate.test(this.stack);
    }

    public boolean canTakeItem(Container c, int i, ItemStack s) {
        return (Boolean)this.level.getBlockState(this.worldPosition).getValue((Property)BlockStateProperties.ENABLED);
    }

    public double getLevelX() {
        return (double)this.worldPosition.getX() + 0.5;
    }

    public double getLevelY() {
        return (double)this.worldPosition.getY() + 0.5;
    }

    public double getLevelZ() {
        return (double)this.worldPosition.getZ() + 0.5;
    }
}

