/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.block_entities.block;

import divinerpg.registries.BlockEntityRegistry;
import divinerpg.util.UniversalPosition;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PortalBlockEntity
extends BlockEntity {
    public UniversalPosition targetPosition;

    public PortalBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.PORTAL.get(), pos, blockState);
    }

    public boolean hasTargetPos() {
        return this.targetPosition != null;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.targetPosition != null) {
            tag.putString("target_dim", this.targetPosition.dimension().location().toString());
            BlockPos p = this.targetPosition.blockPos();
            tag.putInt("target_x", p.getX());
            tag.putInt("target_y", p.getY());
            tag.putInt("target_z", p.getZ());
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("target_x") && tag.contains("target_y") && tag.contains("target_z") && tag.contains("target_dim")) {
            this.targetPosition = new UniversalPosition((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)tag.getString("target_dim"))), new BlockPos(tag.getInt("target_x"), tag.getInt("target_y"), tag.getInt("target_z")));
        }
    }
}

