/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.block_entities.block;

import divinerpg.network.payload.RequestRiftVariant;
import divinerpg.registries.BlockEntityRegistry;
import divinerpg.registries.SoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;

public class RiftBlockEntity
extends BlockEntity {
    public int lifeTime;
    public int maxLifeTime;
    public int clientTickCount;
    public byte variant;

    public RiftBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)BlockEntityRegistry.RIFT.get(), pos, blockState);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("lifetime", this.lifeTime);
        tag.putInt("maxlifetime", this.maxLifeTime);
        tag.putByte("variant", this.variant);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("lifetime")) {
            this.lifeTime = tag.getInt("lifetime");
        }
        if (tag.contains("maxlifetime")) {
            this.maxLifeTime = tag.getInt("maxlifetime");
        }
        if (tag.contains("variant")) {
            this.variant = tag.getByte("variant");
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && this.level.isClientSide()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new RequestRiftVariant(this.worldPosition), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, RiftBlockEntity entity) {
        ++entity.clientTickCount;
        if ((entity.clientTickCount & 0x3F) == 10) {
            level.playLocalSound(pos, (SoundEvent)SoundRegistry.RIFT_AMBIENT.get(), SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        if ((entity.variant & 0x10) == 16 && Math.random() < 0.15) {
            level.playLocalSound(pos, (SoundEvent)SoundRegistry.RIFT_INSTABILITY.get(), SoundSource.BLOCKS, 1.0f, 1.5f - (float)Math.random(), false);
        }
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, RiftBlockEntity entity) {
        entity.lifeTime -= entity.variant & 0x10 | 1;
        int lightLevel = Math.clamp((long)((int)(15.0f * (float)entity.lifeTime / (float)entity.maxLifeTime)), 0, 15);
        if ((Integer)state.getValue((Property)BlockStateProperties.LEVEL) != lightLevel) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.LEVEL, (Comparable)Integer.valueOf(lightLevel)), 2);
        }
        if (entity.lifeTime < 0) {
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        }
    }
}

