/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.block_entities.block;

import divinerpg.network.payload.ItemContentChanged;
import divinerpg.network.payload.RequestItemContent;
import divinerpg.registries.BlockEntityRegistry;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public class RobbinNestBlockEntity
extends BlockEntity
implements Container {
    private static final String ITEM_TAG = "item";
    private ItemStack item;

    public RobbinNestBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)BlockEntityRegistry.ROBBIN_NEST.get(), pos, state);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.getItem() != null && !this.getItem().isEmpty()) {
            tag.put(ITEM_TAG, this.getItem().save(registries));
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains(ITEM_TAG)) {
            this.item = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(ITEM_TAG));
        }
    }

    public void onLoad() {
        super.onLoad();
        if (this.level.isClientSide()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new RequestItemContent(this.worldPosition), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void setItemNoUpdate(ItemStack item) {
        this.item = item;
    }

    public void setItemSilent(ItemStack item) {
        this.item = item;
        this.setChanged();
    }

    public void setItem(ItemStack item) {
        if (!this.level.isClientSide() && (this.item == null ? item != null && !item.isEmpty() : (item == null ? !this.item.isEmpty() : this.item.isEmpty() ^ item.isEmpty()))) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)this.level), (ChunkPos)new ChunkPos(this.worldPosition), (CustomPacketPayload)new ItemContentChanged(this.worldPosition, item.getItem().getDescriptionId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.item = item;
        this.setChanged();
    }

    public void setRemoved() {
        super.setRemoved();
        this.item = ItemStack.EMPTY;
    }

    public ItemStack getItem() {
        return this.getItem(0);
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.item == null || this.item.isEmpty();
    }

    public ItemStack getItem(int i) {
        return this.item == null ? ItemStack.EMPTY : this.item;
    }

    public ItemStack removeItem(int i, int amount) {
        if (this.item == null || this.item.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int count = this.item.getCount() - amount;
        if (count < 1) {
            ItemStack output = this.item.copy();
            this.setItem(ItemStack.EMPTY);
            return output;
        }
        this.setItem(this.item.copyWithCount(count));
        return this.item.copyWithCount(amount);
    }

    public ItemStack removeItemNoUpdate(int amount) {
        if (this.item == null || this.item.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int count = this.item.getCount() - amount;
        if (count < 1) {
            ItemStack output = this.item.copy();
            this.item = ItemStack.EMPTY;
            return output;
        }
        this.item = this.item.copyWithCount(count);
        return this.item.copyWithCount(amount);
    }

    public void setItem(int i, ItemStack stack) {
        this.setItem(stack);
    }

    public boolean stillValid(Player player) {
        return !player.isSpectator();
    }

    public int countItem(Item i) {
        return this.item == null || this.item.isEmpty() || !this.item.is(i) ? 0 : this.item.getCount();
    }

    public boolean hasAnyMatching(Predicate<ItemStack> predicate) {
        return predicate.test(this.item == null ? ItemStack.EMPTY : this.item);
    }

    public void clearContent() {
        this.setItem(ItemStack.EMPTY);
    }
}

