/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.arcana;

import divinerpg.util.BlockSetTypesList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public class BlockArcanaDoor
extends DoorBlock {
    private final ResourceLocation keyItem;

    public BlockArcanaDoor(MapColor color, ResourceLocation key) {
        super(BlockSetTypesList.ARCANA, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BEDROCK).mapColor(color).noOcclusion());
        this.keyItem = key;
    }

    private void updateAdjacentDoors(Level world, BlockPos pos, Player player) {
        BlockPos[] adjacent;
        for (BlockPos adjacentPos : adjacent = new BlockPos[]{pos.north(), pos.east(), pos.south(), pos.west()}) {
            BlockState adjacentState = world.getBlockState(adjacentPos);
            if (!(adjacentState.getBlock() instanceof BlockArcanaDoor)) continue;
            world.setBlockAndUpdate(adjacentPos, (BlockState)adjacentState.cycle((Property)OPEN));
            world.levelEvent(player, (Boolean)adjacentState.getValue((Property)OPEN) != false ? 1005 : 1011, adjacentPos, 0);
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        BlockState iblockstate = pos.equals((Object)pos.below()) ? state : level.getBlockState(pos.below());
        Item key = (Item)BuiltInRegistries.ITEM.get(this.keyItem);
        if (!iblockstate.is((Block)this)) {
            return ItemInteractionResult.FAIL;
        }
        if (!player.isCreative()) {
            if (((Boolean)iblockstate.getValue((Property)OPEN)).equals(true)) {
                return ItemInteractionResult.FAIL;
            }
            if (stack.getItem() != key) {
                return ItemInteractionResult.FAIL;
            }
            player.awardStat(Stats.ITEM_USED.get((Object)key));
        }
        stack.consume(1, (LivingEntity)player);
        level.setBlockAndUpdate(pos, (BlockState)state.cycle((Property)OPEN));
        level.levelEvent(player, (Boolean)state.getValue((Property)OPEN) != false ? 1005 : 1011, pos, 0);
        if (((Boolean)state.getValue((Property)OPEN)).booleanValue()) {
            level.playSound(player, pos, SoundEvents.IRON_DOOR_CLOSE, SoundSource.BLOCKS, 1.0f, 0.8f);
        } else {
            level.playSound(player, pos, SoundEvents.IRON_DOOR_OPEN, SoundSource.BLOCKS, 1.0f, 0.8f);
        }
        this.updateAdjacentDoors(level, pos, player);
        return ItemInteractionResult.SUCCESS;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPosition, boolean isPowered) {
    }
}

