/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.arcana;

import divinerpg.blocks.base.BlockMod;
import divinerpg.registries.SoundRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockElevantium
extends BlockMod {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    protected static final VoxelShape ELEVANTIUM = Shapes.or((VoxelShape)BlockElevantium.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0), (VoxelShape)BlockElevantium.box((double)4.5, (double)1.0, (double)4.5, (double)11.5, (double)2.0, (double)11.5));

    public BlockElevantium() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DIAMOND_BLOCK).mapColor(MapColor.COLOR_LIGHT_BLUE).pushReaction(PushReaction.DESTROY));
        ((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        boolean canJump;
        int signal = level.getBestNeighborSignal(pos);
        boolean bl = canJump = !level.getBlockCollisions(entity, entity.getBoundingBox().expandTowards(0.0, 2.0, 0.0)).iterator().hasNext();
        if (signal > 0 && !entity.isSuppressingBounce() && canJump) {
            entity.push(0.0, (double)signal * 0.25, 0.0);
            level.playSound(null, pos, (SoundEvent)SoundRegistry.CONSTRUCTOR_PUNCH.get(), SoundSource.BLOCKS, 0.75f, 0.9f);
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!level.isClientSide && (flag = ((Boolean)state.getValue((Property)POWERED)).booleanValue()) != level.hasNeighborSignal(pos)) {
            if (flag) {
                level.scheduleTick(pos, (Block)this, 4);
            } else {
                level.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
            }
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && !level.hasNeighborSignal(pos)) {
            level.setBlock(pos, (BlockState)state.cycle((Property)POWERED), 2);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ELEVANTIUM;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Shapes.create((AABB)ELEVANTIUM.bounds().inflate(0.0625, 0.125, 0.0625));
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }
}

