/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import divinerpg.registries.BlockRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockModCrop
extends CropBlock {
    private final ItemLike seed;
    private static final VoxelShape[] DEFAULT = BlockModCrop.createHeightByAge(new int[]{3, 6, 9, 11, 11, 11, 11, 11});
    private static final VoxelShape[] EUCALYPTUS = BlockModCrop.createHeightByAge(new int[]{3, 5, 5, 7, 8, 10, 12, 14});

    private static VoxelShape[] createHeightByAge(int[] heights) {
        VoxelShape[] shapes = new VoxelShape[heights.length];
        for (int i = 0; i < heights.length; ++i) {
            shapes[i] = BlockModCrop.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)heights[i], (double)16.0);
        }
        return shapes;
    }

    public BlockModCrop(ItemLike seed) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT));
        this.seed = seed;
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        VoxelShape[] shapes = this == BlockRegistry.eucalyptusPlant.get() ? EUCALYPTUS : DEFAULT;
        return shapes[(Integer)state.getValue((Property)this.getAgeProperty())];
    }

    protected ItemLike getBaseSeedId() {
        return this.seed;
    }
}

