/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.CommonHooks;

public class BlockModDoubleCrop
extends SugarCaneBlock {
    private final ItemLike seed;

    public BlockModDoubleCrop(int lightLevel, ItemLike seed) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WHEAT).lightLevel(state -> lightLevel));
        this.seed = seed;
    }

    public BlockModDoubleCrop(ItemLike seed) {
        this(0, seed);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.isEmptyBlock(pos.above())) {
            int i = 1;
            while (level.getBlockState(pos.below(i)).is((Block)this)) {
                ++i;
            }
            if (i < 3) {
                int j = (Integer)state.getValue((Property)AGE);
                if (CommonHooks.canCropGrow((Level)level, (BlockPos)pos, (BlockState)state, (boolean)true)) {
                    if (j == 15) {
                        level.setBlockAndUpdate(pos.above(), this.defaultBlockState());
                        CommonHooks.fireCropGrowPost((Level)level, (BlockPos)pos.above(), (BlockState)this.defaultBlockState());
                        level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(14)), 2);
                    } else {
                        level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(j + 1)), 4);
                    }
                }
            }
        }
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState blockstate = level.getBlockState(pos.relative(direction));
            if (!blockstate.hasLargeCollisionShape() && !level.getFluidState(pos.relative(direction)).is(FluidTags.LAVA)) continue;
            return false;
        }
        BlockState belowState = level.getBlockState(pos.below());
        return (level.getRawBrightness(pos, 0) >= 8 || level.canSeeSky(pos)) && (belowState.is(BlockTags.DIRT) || belowState.is((Block)this) && (Integer)belowState.getValue((Property)AGE) == 14);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack(this.seed);
    }
}

