/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;

public class BlockModFenceRedstone
extends FenceBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public BlockModFenceRedstone(MapColor color) {
        super(BlockBehaviour.Properties.of().mapColor(color).dynamicShape().strength(0.3f).sound(SoundType.GLASS).instrument(NoteBlockInstrument.HAT));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)POWERED) != false ? 15 : 0;
    }

    public void onPlace(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.handleBlockState(state, worldIn, pos);
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.handleBlockState(state, worldIn, pos);
        DebugPackets.sendNeighborsUpdatePacket((Level)worldIn, (BlockPos)pos);
    }

    public void tick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        this.handleBlockState(state, (Level)worldIn, pos);
    }

    public void handleBlockState(BlockState state, Level worldIn, BlockPos pos) {
        if (!worldIn.isClientSide) {
            if (((Boolean)state.getValue((Property)POWERED)).booleanValue() && !worldIn.hasNeighborSignal(pos)) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)), 2);
            } else if (!((Boolean)state.getValue((Property)POWERED)).booleanValue() && worldIn.hasNeighborSignal(pos)) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{NORTH, EAST, WEST, SOUTH, WATERLOGGED, POWERED});
    }
}

