/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;

public class BlockModFlower
extends FlowerBlock {
    private final boolean canGrowOnSand;

    public BlockModFlower(Holder<MobEffect> mobEffects, float seconds, MapColor color, boolean canGrowOnSand) {
        super(mobEffects, seconds, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POPPY).mapColor(color).sound(SoundType.CROP));
        this.canGrowOnSand = canGrowOnSand;
    }

    public BlockModFlower(Holder<MobEffect> mobEffects, float seconds, MapColor color) {
        this(mobEffects, seconds, color, false);
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return this.canGrowOnSand ? super.mayPlaceOn(state, level, pos) || state.is(BlockTags.SAND) : super.mayPlaceOn(state, level, pos);
    }

    public int getFlammability(BlockState state, BlockGetter getter, BlockPos pos, Direction face) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter getter, BlockPos pos, Direction face) {
        return 60;
    }

    public MapCodec<? extends FlowerBlock> codec() {
        return null;
    }
}

