/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import divinerpg.registries.BlockRegistry;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.MapColor;

public class BlockModGrassBlock
extends GrassBlock {
    private final boolean requiresLightToRegrow;
    protected final Supplier<Block> dirtSupplier;

    public BlockModGrassBlock(Supplier<Block> dirt, MapColor color, boolean requiresLightToRegrow) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRASS_BLOCK).mapColor(color));
        this.dirtSupplier = dirt;
        this.requiresLightToRegrow = requiresLightToRegrow;
    }

    public BlockModGrassBlock(Supplier<Block> dirt, MapColor color) {
        this(dirt, color, true);
    }

    public BlockModGrassBlock(Supplier<Block> dirt) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRIMSON_NYLIUM).mapColor(MapColor.COLOR_CYAN).strength(2.0f, 6.0f));
        this.dirtSupplier = dirt;
        this.requiresLightToRegrow = false;
    }

    public BlockState grass() {
        if (this == BlockRegistry.rayGrass.get()) {
            return ((Block)BlockRegistry.edenBrush.get()).defaultBlockState();
        }
        if (this == BlockRegistry.wildwoodGrass.get()) {
            return ((Block)BlockRegistry.moonlightFern.get()).defaultBlockState();
        }
        if (this == BlockRegistry.apalachiaGrass.get()) {
            return ((Block)BlockRegistry.apalachiaTallgrass.get()).defaultBlockState();
        }
        if (this == BlockRegistry.skythernGrass.get()) {
            return ((Block)BlockRegistry.skythernBrush.get()).defaultBlockState();
        }
        if (this == BlockRegistry.mortumGrass.get()) {
            return ((Block)BlockRegistry.mortumBrush.get()).defaultBlockState();
        }
        return null;
    }

    public void place(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (random.nextBoolean()) {
            pos = pos.relative(Direction.getRandom((RandomSource)random));
        }
        BlockPos above = pos.above();
        if (BlockModGrassBlock.canPropagate(state, (LevelReader)level, pos)) {
            BlockState grass;
            if (level.getBlockState(pos).is(this.dirtSupplier.get())) {
                level.setBlock(pos, state, 3);
            } else if (level.getBlockState(pos).is((Block)this) && (grass = this.grass()) != null) {
                level.setBlock(above, grass, 3);
            }
        }
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockState myState = this.defaultBlockState();
        this.place(level, random, pos.above(), myState);
        this.place(level, random, pos.below(), myState);
        this.place(level, random, pos.north(), myState);
        this.place(level, random, pos.east(), myState);
        this.place(level, random, pos.south(), myState);
        this.place(level, random, pos.west(), myState);
    }

    private static boolean canBeGrass(BlockState state, LevelReader levelReader, BlockPos pos) {
        BlockPos blockpos = pos.above();
        BlockState blockstate = levelReader.getBlockState(blockpos);
        if (blockstate.is(Blocks.SNOW) && ((Integer)blockstate.getValue((Property)SnowLayerBlock.LAYERS) == 1 || state.getBlock() == BlockRegistry.frozenGrass.get())) {
            return true;
        }
        if (blockstate.getFluidState().getAmount() == 8) {
            return false;
        }
        int i = LightEngine.getLightBlockInto((BlockGetter)levelReader, (BlockState)state, (BlockPos)pos, (BlockState)blockstate, (BlockPos)blockpos, (Direction)Direction.UP, (int)blockstate.getLightBlock((BlockGetter)levelReader, blockpos));
        return i < levelReader.getMaxLightLevel();
    }

    private static boolean canPropagate(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.above();
        return BlockModGrassBlock.canBeGrass(state, level, pos) && !level.getFluidState(blockpos).is(FluidTags.WATER);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!BlockModGrassBlock.canBeGrass(state, (LevelReader)level, pos)) {
            if (!level.isAreaLoaded(pos, 1)) {
                return;
            }
            level.setBlockAndUpdate(pos, this.dirtSupplier.get().defaultBlockState());
        } else {
            if (!level.isAreaLoaded(pos, 3)) {
                return;
            }
            if (level.getMaxLocalRawBrightness(pos.above()) >= 9 || !this.requiresLightToRegrow) {
                BlockState blockstate = this.defaultBlockState();
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = pos.offset(random.nextInt(3) - 1, random.nextInt(5) - 3, random.nextInt(3) - 1);
                    if (!level.getBlockState(blockpos).is(this.dirtSupplier.get()) || !BlockModGrassBlock.canPropagate(blockstate, (LevelReader)level, blockpos)) continue;
                    level.setBlockAndUpdate(blockpos, (BlockState)blockstate.setValue((Property)SNOWY, (Comparable)Boolean.valueOf(level.getBlockState(blockpos.above()).is(Blocks.SNOW))));
                }
            }
        }
    }
}

