/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import divinerpg.blocks.base.BlockMod;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;

public class BlockModMobCage
extends BlockMod {
    public final ResourceLocation type;
    public final TagKey<Item> spawnItem;
    protected final BlockPos relativePos;

    public BlockModMobCage(BlockBehaviour.Properties properties, ResourceLocation type, @Nullable TagKey<Item> spawnItem, @Nullable BlockPos relativePos) {
        super(properties.pushReaction(PushReaction.BLOCK));
        this.type = type;
        this.spawnItem = spawnItem;
        this.relativePos = relativePos;
    }

    public BlockModMobCage(ResourceLocation type, TagKey<Item> spawnItem) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPAWNER).noOcclusion().pushReaction(PushReaction.BLOCK));
        this.type = type;
        this.spawnItem = spawnItem;
        this.relativePos = null;
    }

    public BlockModMobCage(ResourceLocation type, TagKey<Item> spawnItem, MapColor color) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPAWNER).noOcclusion().pushReaction(PushReaction.BLOCK).mapColor(color));
        this.type = type;
        this.spawnItem = spawnItem;
        this.relativePos = null;
    }

    public BlockModMobCage(ResourceLocation type, @Nullable TagKey<Item> spawnItem, MapColor color, @Nullable BlockPos relativePos) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SPAWNER).noOcclusion().pushReaction(PushReaction.BLOCK).mapColor(color));
        this.type = type;
        this.spawnItem = spawnItem;
        this.relativePos = relativePos;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (!level.isClientSide && !player.isCreative()) {
            ((EntityType)BuiltInRegistries.ENTITY_TYPE.get(this.type)).spawn((ServerLevel)level, null, player, this.relativePos == null ? pos : pos.offset((Vec3i)this.relativePos), MobSpawnType.MOB_SUMMONED, true, false);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!player.getCooldowns().isOnCooldown(stack.getItem()) && (this.spawnItem == null || stack.is((HolderSet)BuiltInRegistries.ITEM.getOrCreateTag(this.spawnItem)) && !stack.is(Items.AIR))) {
            if (!level.isClientSide) {
                ((EntityType)BuiltInRegistries.ENTITY_TYPE.get(this.type)).spawn((ServerLevel)level, null, player, this.relativePos == null ? pos : pos.offset((Vec3i)this.relativePos), MobSpawnType.MOB_SUMMONED, true, false);
            }
            if (this.spawnItem != null) {
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                stack.consume(1, (LivingEntity)player);
            }
            player.getCooldowns().addCooldown(stack.getItem(), 40);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }
}

