/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.MossBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BlockModMoss
extends MossBlock {
    public BlockModMoss(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return level.getBlockState(pos.below()).isAir();
    }

    public void performBonemeal(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        BlockState myState = this.defaultBlockState();
        this.place(level, random, pos.above(), myState);
        this.place(level, random, pos.below(), myState);
        this.place(level, random, pos.north(), myState);
        this.place(level, random, pos.east(), myState);
        this.place(level, random, pos.south(), myState);
        this.place(level, random, pos.west(), myState);
    }

    public void place(ServerLevel level, RandomSource random, BlockPos pos, BlockState state) {
        if (random.nextBoolean()) {
            pos = pos.relative(Direction.getRandom((RandomSource)random));
        }
        if (level.getBlockState(pos).is(BlockTags.MOSS_REPLACEABLE)) {
            level.setBlock(pos, state, 3);
        }
    }
}

