/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import divinerpg.block_entities.bosses.StatueBlockEntity;
import divinerpg.blocks.base.BlockMod;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockStatue
extends BlockMod
implements EntityBlock {
    private static final int ROTATIONS = RotationSegment.getMaxSegmentIndex() + 1;
    public static final IntegerProperty ROTATION = BlockStateProperties.ROTATION_16;
    private final Supplier<SoundEvent> statueSound;

    public BlockStatue(Supplier<SoundEvent> soundIn) {
        super(BlockBehaviour.Properties.of().strength(2.0f, 6.0f).noOcclusion().requiresCorrectToolForDrops());
        this.statueSound = soundIn;
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)ROTATION, (Comparable)Integer.valueOf(0)));
    }

    public boolean skipRendering(BlockState state, BlockState state1, Direction dir) {
        return true;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new StatueBlockEntity(pos, state);
    }

    public InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult trace) {
        if (player.isCrouching() && !player.getMainHandItem().isEmpty() || this.statueSound == null) {
            return InteractionResult.PASS;
        }
        world.playSound(player, pos, this.statueSound.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)ROTATION, (Comparable)Integer.valueOf(RotationSegment.convertToSegment((float)context.getRotation())));
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(rotation.rotate(((Integer)state.getValue((Property)ROTATION)).intValue(), ROTATIONS)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)ROTATION, (Comparable)Integer.valueOf(mirror.mirror(((Integer)state.getValue((Property)ROTATION)).intValue(), ROTATIONS)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{ROTATION});
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return Shapes.create((AABB)new AABB(0.2, 0.0, 0.2, 0.8, 1.0, 0.8));
    }
}

