/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import divinerpg.DivineRPG;
import divinerpg.block_entities.block.PortalBlockEntity;
import divinerpg.blocks.base.SimplePortalBlock;
import divinerpg.registries.BlockEntityRegistry;
import divinerpg.util.DivinePortalLogic;
import divinerpg.util.UniversalPosition;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.portal.DimensionTransition;
import org.jetbrains.annotations.Nullable;

public abstract class PortalBlock
extends BaseEntityBlock
implements DivinePortalLogic {
    public final ResourceKey<Level> rootDimension;
    public final ResourceKey<Level> chainDimension;
    public final Block frameBlock;
    public final ResourceLocation particleLocation;
    public SimpleParticleType particle;
    public static final MapCodec<PortalBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PortalBlock.propertiesCodec(), (App)ResourceLocation.CODEC.fieldOf("target_dimension").forGetter(PortalBlock::rootDimensionLocation), (App)ResourceLocation.CODEC.fieldOf("chain_dimension").forGetter(PortalBlock::chainDimension), (App)Block.CODEC.fieldOf("frame_block").forGetter(PortalBlock::frameBlock), (App)ResourceLocation.CODEC.fieldOf("particle").forGetter(PortalBlock::particle)).apply((Applicative)instance, SimplePortalBlock::new));

    public PortalBlock(BlockBehaviour.Properties properties, ResourceKey<Level> rootDimension, ResourceKey<Level> chainDimension, Block frameBlock, ResourceLocation particle) {
        super(properties);
        this.rootDimension = rootDimension;
        this.chainDimension = chainDimension;
        this.frameBlock = frameBlock;
        this.particleLocation = particle;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntityRegistry.PORTAL.get()).create(pos, state);
    }

    @Override
    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        DivinePortalLogic.super.entityInside(state, level, pos, entity);
    }

    @Override
    @Nullable
    public DimensionTransition getSimpleConnection(ServerLevel level, Entity entity, BlockPos pos) {
        BlockPos targetPos;
        UniversalPosition target;
        ServerLevel targetLevel;
        PortalBlockEntity p;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PortalBlockEntity && (p = (PortalBlockEntity)blockEntity).hasTargetPos() && (targetLevel = (target = p.targetPosition).level(level.getServer())).getBlockState(targetPos = target.blockPos()).is((Block)this)) {
            return DivinePortalLogic.transitionTo(targetLevel, entity, targetPos);
        }
        return null;
    }

    @Override
    public UniversalPosition getTargetLocation(ServerLevel source, Entity entity, BlockPos pos) {
        ResourceKey<Level> targetDimension = source.dimension() == this.rootDimension ? this.chainDimension : this.rootDimension;
        return new UniversalPosition(targetDimension, DivinePortalLogic.scalePosition(pos, source.dimensionType(), source.getServer().getLevel(targetDimension).dimensionType()));
    }

    @Override
    @Nullable
    public BlockPos lookForNearbyPortal(ServerLevel level, Entity entity, BlockPos center) {
        BlockPos.MutableBlockPos m = center.mutable().move(-5, -2, -5);
        for (int x = 0; x < 11; ++x) {
            for (int y = 0; y < 5; ++y) {
                for (int z = 0; z < 11; ++z) {
                    if (level.getBlockState((BlockPos)m).is((Block)this)) {
                        return m;
                    }
                    m.move(0, 0, 1);
                }
                m.move(0, 1, -11);
            }
            m.move(1, -5, 0);
        }
        return null;
    }

    @Override
    public void link(ServerLevel originLevel, BlockPos originPos, ServerLevel targetLevel, BlockPos targetPos) {
        this.link(originLevel, originPos, new UniversalPosition((Level)targetLevel, targetPos), new ArrayList<BlockPos>(9));
        this.link(targetLevel, targetPos, new UniversalPosition((Level)originLevel, originPos), new ArrayList<BlockPos>(9));
    }

    public void link(ServerLevel level, BlockPos pos, UniversalPosition link, List<BlockPos> updated) {
        BlockEntity blockEntity;
        if (updated.contains(pos)) {
            return;
        }
        BlockState state = level.getBlockState(pos);
        if (state.is((Block)this) && (blockEntity = level.getBlockEntity(pos)) instanceof PortalBlockEntity) {
            PortalBlockEntity p = (PortalBlockEntity)blockEntity;
            p.targetPosition = link;
            updated.add(pos);
            if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
                Direction.Axis axis = (Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
                this.link(level, pos.above(), link, updated);
                this.link(level, pos.below(), link, updated);
                this.link(level, pos.relative(axis, 1), link, updated);
                this.link(level, pos.relative(axis, -1), link, updated);
            } else {
                this.link(level, pos.north(), link, updated);
                this.link(level, pos.south(), link, updated);
                this.link(level, pos.east(), link, updated);
                this.link(level, pos.west(), link, updated);
            }
        }
    }

    @Override
    public boolean hasSpace(ServerLevel level, BlockPos pos) {
        return level.getBlockState(pos.above()).isAir() && level.getBlockState(pos).isAir();
    }

    @Override
    public BlockPos placeAndLink(ServerLevel originLevel, BlockPos originPos, ServerLevel targetLevel, BlockPos targetPos, Entity entity) {
        BlockState state = originLevel.getBlockState(originPos);
        if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
            PortalBlock.placeVanillaLookingPortal(targetLevel, targetPos, this.frameBlock.defaultBlockState(), state, (Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS), new UniversalPosition((Level)originLevel, originPos));
            this.link(originLevel, originPos, new UniversalPosition((Level)targetLevel, targetPos), new ArrayList<BlockPos>(9));
        }
        return targetPos;
    }

    public static void placeVanillaLookingPortal(ServerLevel level, BlockPos pos, BlockState frameBlock, BlockState portalBlock, Direction.Axis axis, UniversalPosition link) {
        if (!level.ensureCanWrite(pos)) {
            return;
        }
        Direction.Axis other = axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
        BlockState air = Blocks.AIR.defaultBlockState();
        BlockPos.MutableBlockPos mut = PortalBlock.below(pos.mutable());
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.relative(mut, axis, -1), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.above(mut), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.above(mut), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.above(mut), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.above(mut), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.relative(mut, axis, 1), frameBlock);
        PortalBlock.setPortal(level, (BlockPos)PortalBlock.below(mut), portalBlock, link);
        PortalBlock.setPortal(level, (BlockPos)PortalBlock.below(mut), portalBlock, link);
        PortalBlock.setPortal(level, (BlockPos)PortalBlock.below(mut), portalBlock, link);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.below(mut), frameBlock);
        if (level.getBlockState((BlockPos)PortalBlock.relative(mut, other, 1)).isAir()) {
            level.setBlock((BlockPos)mut, frameBlock, 16);
        }
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.above(mut), air);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.above(mut), air);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.above(mut), air);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.relative(mut, axis, 1), air);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.below(mut), air);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.below(mut), air);
        if (level.getBlockState((BlockPos)PortalBlock.below(mut)).isAir()) {
            level.setBlock((BlockPos)mut, frameBlock, 16);
        }
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.relative(mut, other, -1), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.relative(mut, axis, 1), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.above(mut), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.above(mut), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.above(mut), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.above(mut), frameBlock);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.relative(mut, axis, -1), frameBlock);
        PortalBlock.setPortal(level, (BlockPos)PortalBlock.below(mut), portalBlock, link);
        PortalBlock.setPortal(level, (BlockPos)PortalBlock.below(mut), portalBlock, link);
        PortalBlock.setPortal(level, (BlockPos)PortalBlock.below(mut), portalBlock, link);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.relative(mut, other, -1), air);
        if (level.getBlockState((BlockPos)PortalBlock.below(mut)).isAir()) {
            level.setBlock((BlockPos)mut, frameBlock, 16);
        }
        if (level.getBlockState((BlockPos)PortalBlock.relative(mut, axis, -1)).isAir()) {
            level.setBlock((BlockPos)mut, frameBlock, 16);
        }
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.above(mut), air);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.above(mut), air);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.above(mut), air);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.relative(mut, axis, 1), air);
        PortalBlock.setBlock(level, (BlockPos)PortalBlock.below(mut), air);
    }

    public static BlockPos.MutableBlockPos relative(BlockPos.MutableBlockPos pos, Direction.Axis axis, int amount) {
        return pos.move(axis.choose(amount, 0, 0), 0, axis.choose(0, 0, amount));
    }

    public static BlockPos.MutableBlockPos above(BlockPos.MutableBlockPos pos) {
        return pos.move(0, 1, 0);
    }

    public static BlockPos.MutableBlockPos below(BlockPos.MutableBlockPos pos) {
        return pos.move(0, -1, 0);
    }

    public static void setBlock(ServerLevel level, BlockPos pos, BlockState state) {
        BlockState block = level.getBlockState(pos);
        if (state.isAir() || block.getBlock().defaultDestroyTime() > -1.0f) {
            level.setBlock(pos, state, 16);
        }
    }

    public static void setPortal(ServerLevel level, BlockPos pos, BlockState state, UniversalPosition link) {
        BlockState block = level.getBlockState(pos);
        if (state.isAir() || block.getBlock().defaultDestroyTime() > -1.0f) {
            level.setBlock(pos, state, 16);
            PortalBlockEntity portal = (PortalBlockEntity)((BlockEntityType)BlockEntityRegistry.PORTAL.get()).create(pos, state);
            portal.targetPosition = link;
            level.setBlockEntity((BlockEntity)portal);
        }
    }

    public static void spreadBlock(Level level, BlockState newState, BlockPos pos, Block spreadTarget, Direction.Axis axis) {
        BlockState state = level.getBlockState(pos);
        if (state.is(spreadTarget) && !state.is(newState.getBlock())) {
            level.setBlock(pos, newState, 16);
            PortalBlock.spreadBlock(level, newState, pos.above(), spreadTarget, axis);
            PortalBlock.spreadBlock(level, newState, pos.below(), spreadTarget, axis);
            PortalBlock.spreadBlock(level, newState, pos.relative(axis, 1), spreadTarget, axis);
            PortalBlock.spreadBlock(level, newState, pos.relative(axis, -1), spreadTarget, axis);
        }
        level.sendBlockUpdated(pos, spreadTarget.defaultBlockState(), newState, 3);
    }

    public Direction.Axis checkForFrame(Level level, BlockPos pos) {
        Direction d = null;
        for (Direction di : Direction.values()) {
            if (!level.getBlockState(pos.relative(di)).is(this.frameBlock)) continue;
            d = di;
            break;
        }
        if (d == null) {
            return null;
        }
        return this.travel(level, pos, Direction.Axis.X) ? Direction.Axis.X : (this.travel(level, pos, Direction.Axis.Z) ? Direction.Axis.Z : null);
    }

    protected boolean travel(Level level, BlockPos pos, Direction.Axis axis) {
        BlockState state;
        Direction d;
        Direction dir = d = this.lookForFrameBlock(level, pos, axis);
        if (d == null) {
            return false;
        }
        BlockPos.MutableBlockPos mut = pos.mutable();
        while ((dir = dir.getClockWise(axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X)) != d) {
            state = level.getBlockState(mut.relative(dir));
            if (state.is(this.frameBlock)) continue;
            if (state.isAir()) break;
            return false;
        }
        if (dir == d) {
            return true;
        }
        d = dir;
        mut.move(d);
        while (mut.distManhattan((Vec3i)pos) < 33 && !mut.equals((Object)pos)) {
            if (!level.getBlockState(mut.relative(d.getCounterClockWise(axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X))).is(this.frameBlock)) {
                return false;
            }
            do {
                if ((state = level.getBlockState(mut.relative(dir))).is(this.frameBlock)) continue;
                if (state.isAir()) {
                    d = dir;
                    break;
                }
                return false;
            } while ((dir = dir.getClockWise(axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X)) != d);
            mut.move(d);
        }
        return level.getBlockState(mut.relative(d.getCounterClockWise(axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X))).is(this.frameBlock) && mut.equals((Object)pos);
    }

    protected Direction lookForFrameBlock(Level level, BlockPos pos, Direction.Axis axis) {
        Direction d;
        Direction dir = d = axis == Direction.Axis.X ? Direction.EAST : Direction.SOUTH;
        do {
            if (!level.getBlockState(pos.relative(dir)).is(this.frameBlock)) continue;
            return dir;
        } while ((dir = dir.getClockWise(axis == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X)) != d);
        return null;
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        return this.isSupported(state, (LevelReader)level, pos) ? state : Blocks.AIR.defaultBlockState();
    }

    protected void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pNeighborBlock, BlockPos pNeighborPos, boolean pMovedByPiston) {
        if (!this.isSupported(pState, (LevelReader)pLevel, pPos)) {
            pLevel.setBlock(pPos, Blocks.AIR.defaultBlockState(), 3);
        } else {
            super.neighborChanged(pState, pLevel, pPos, pNeighborBlock, pNeighborPos, pMovedByPiston);
        }
    }

    public abstract boolean isSupported(BlockState var1, LevelReader var2, BlockPos var3);

    public boolean supportedBy(BlockState state) {
        return state.is(BlockTags.PORTALS) || state.is(this.frameBlock);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Override
    public ResourceKey<Level> rootDimension() {
        return this.rootDimension;
    }

    public ResourceLocation rootDimensionLocation() {
        return this.rootDimension.location();
    }

    public ResourceLocation chainDimension() {
        return this.chainDimension.location();
    }

    public ResourceLocation particle() {
        return this.particleLocation;
    }

    public Block frameBlock() {
        return this.frameBlock;
    }

    protected abstract void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var1);

    public boolean canBeReplaced(BlockState state, Fluid fluid) {
        return false;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (this.particleLocation != null) {
            if (this.particle == null) {
                this.particle = (SimpleParticleType)BuiltInRegistries.PARTICLE_TYPE.get(this.particleLocation);
                if (this.particle == null) {
                    DivineRPG.LOGGER.warn("Null particle ResourceLocation");
                }
            }
            level.addParticle((ParticleOptions)this.particle, (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }
}

