/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.base;

import divinerpg.blocks.base.PortalBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SimplePortalBlock
extends PortalBlock {
    public static final VoxelShape X_AXIS_AABB = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    public static final VoxelShape Z_AXIS_AABB = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public SimplePortalBlock(ResourceKey<Level> rootDimension, ResourceKey<Level> chainDimension, Block frameBlock, ResourceLocation particle) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.NETHER_PORTAL), rootDimension, chainDimension, frameBlock, particle);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)Direction.Axis.X));
    }

    public SimplePortalBlock(BlockBehaviour.Properties properties, ResourceLocation rootDimension, ResourceLocation chainDimension, Block frameBlock, ResourceLocation particle) {
        super(properties, (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)rootDimension), (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)chainDimension), frameBlock, particle);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)Direction.Axis.X));
    }

    @Override
    public boolean isSupported(BlockState state, LevelReader level, BlockPos pos) {
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS);
        return this.supportedBy(level.getBlockState(pos.above())) && this.supportedBy(level.getBlockState(pos.below())) && this.supportedBy(level.getBlockState(pos.relative(axis, 1))) && this.supportedBy(level.getBlockState(pos.relative(axis, -1)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_AXIS});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.rotate((BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)context.getHorizontalDirection().getAxis()), Rotation.CLOCKWISE_90);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS) == Direction.Axis.Z ? Z_AXIS_AABB : X_AXIS_AABB;
    }

    protected BlockState rotate(BlockState state, Rotation rot) {
        return switch (rot) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> {
                switch ((Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)) {
                    case Z: {
                        yield (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        yield (BlockState)state.setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }
}

