/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.iceika;

import com.mojang.serialization.MapCodec;
import divinerpg.block_entities.block.FrostedAllureBlockEntity;
import divinerpg.registries.BlockEntityRegistry;
import divinerpg.registries.TagRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class BlockFrostedAllure
extends BaseEntityBlock {
    public static final MapCodec<BlockFrostedAllure> CODEC = BlockFrostedAllure.simpleCodec(BlockFrostedAllure::new);
    public static final IntegerProperty CATEGORY = IntegerProperty.create((String)"category", (int)0, (int)5);

    public MapCodec<BlockFrostedAllure> codec() {
        return CODEC;
    }

    public BlockFrostedAllure(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.COLOR_LIGHT_BLUE).strength(0.8f).sound(SoundType.CALCITE).instrument(NoteBlockInstrument.CHIME).randomTicks());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CATEGORY, (Comparable)Integer.valueOf(0)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FrostedAllureBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : BlockFrostedAllure.createTickerHelper(type, (BlockEntityType)((BlockEntityType)BlockEntityRegistry.FROSTED_ALLURE.get()), FrostedAllureBlockEntity::serverTick);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{CATEGORY});
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(TagRegistry.FROSTED_ALLURE_CYCLE_ITEMS)) {
            int currentCategory = (Integer)state.getValue((Property)CATEGORY);
            String[] messages = new String[]{"frosted_allure.all", "frosted_allure.monster", "frosted_allure.creature", "frosted_allure.ambient", "frosted_allure.water", "frosted_allure.misc"};
            int newCategory = (currentCategory + 1) % messages.length;
            level.setBlock(pos, (BlockState)state.setValue((Property)CATEGORY, (Comparable)Integer.valueOf(newCategory)), 0);
            player.displayClientMessage(LocalizeUtils.clientMessage(messages[newCategory], new Object[0]), true);
            stack.consume(1, (LivingEntity)player);
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add(LocalizeUtils.i18n("frosted_allure"));
        super.appendHoverText(stack, context, tooltip, flagIn);
    }
}

