/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.iceika;

import com.google.common.annotations.VisibleForTesting;
import divinerpg.registries.BlockRegistry;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockIcicle
extends Block
implements Fallable,
SimpleWaterloggedBlock {
    public static final DirectionProperty TIP_DIRECTION = BlockStateProperties.VERTICAL_DIRECTION;
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.DRIPSTONE_THICKNESS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);

    public BlockIcicle() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.ICE).noOcclusion().sound(SoundType.GLASS).randomTicks().strength(0.5f).pushReaction(PushReaction.DESTROY).dynamicShape().offsetType(BlockBehaviour.OffsetType.XZ));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)TIP_DIRECTION, (Comparable)Direction.UP)).setValue(THICKNESS, (Comparable)DripstoneThickness.TIP)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_154157_) {
        p_154157_.add(new Property[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    public boolean canSurvive(BlockState p_154137_, LevelReader p_154138_, BlockPos p_154139_) {
        return BlockIcicle.isValidPointedDripstonePlacement(p_154138_, p_154139_, (Direction)p_154137_.getValue((Property)TIP_DIRECTION));
    }

    public BlockState updateShape(BlockState p_154147_, Direction p_154148_, BlockState p_154149_, LevelAccessor p_154150_, BlockPos p_154151_, BlockPos p_154152_) {
        if (((Boolean)p_154147_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_154150_.scheduleTick(p_154151_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)p_154150_));
        }
        if (p_154148_ != Direction.UP && p_154148_ != Direction.DOWN) {
            return p_154147_;
        }
        Direction direction = (Direction)p_154147_.getValue((Property)TIP_DIRECTION);
        if (direction == Direction.DOWN && p_154150_.getBlockTicks().hasScheduledTick(p_154151_, (Object)this)) {
            return p_154147_;
        }
        if (p_154148_ == direction.getOpposite() && !this.canSurvive(p_154147_, (LevelReader)p_154150_, p_154151_)) {
            if (direction == Direction.DOWN) {
                p_154150_.scheduleTick(p_154151_, (Block)this, 2);
            } else {
                p_154150_.scheduleTick(p_154151_, (Block)this, 1);
            }
            return p_154147_;
        }
        boolean flag = p_154147_.getValue(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstonethickness = BlockIcicle.calculateDripstoneThickness((LevelReader)p_154150_, p_154151_, direction, flag);
        return (BlockState)p_154147_.setValue(THICKNESS, (Comparable)dripstonethickness);
    }

    public void onProjectileHit(Level p_154042_, BlockState p_154043_, BlockHitResult p_154044_, Projectile p_154045_) {
        BlockPos blockpos = p_154044_.getBlockPos();
        if (!p_154042_.isClientSide && p_154045_.mayInteract(p_154042_, blockpos) && p_154045_ instanceof ThrownTrident && p_154045_.getDeltaMovement().length() > 0.6) {
            p_154042_.destroyBlock(blockpos, true);
        }
    }

    public void fallOn(Level p_154047_, BlockState p_154048_, BlockPos p_154049_, Entity p_154050_, float p_154051_) {
        if (p_154048_.getValue((Property)TIP_DIRECTION) == Direction.UP && p_154048_.getValue(THICKNESS) == DripstoneThickness.TIP) {
            p_154050_.causeFallDamage(p_154051_ + 2.0f, 2.0f, p_154047_.damageSources().stalagmite());
        } else {
            super.fallOn(p_154047_, p_154048_, p_154049_, p_154050_, p_154051_);
        }
    }

    public void tick(BlockState p_221865_, ServerLevel p_221866_, BlockPos p_221867_, RandomSource p_221868_) {
        if (BlockIcicle.isStalagmite(p_221865_) && !this.canSurvive(p_221865_, (LevelReader)p_221866_, p_221867_)) {
            p_221866_.destroyBlock(p_221867_, true);
        } else {
            BlockIcicle.spawnFallingStalactite(p_221865_, p_221866_, p_221867_);
        }
        if (p_221868_.nextBoolean()) {
            this.randomTick(p_221865_, p_221866_, p_221867_, p_221868_);
        }
    }

    public void randomTick(BlockState p_221883_, ServerLevel p_221884_, BlockPos p_221885_, RandomSource p_221886_) {
        if (p_221886_.nextFloat() < 0.011377778f && BlockIcicle.isStalactiteStartPos(p_221883_, (LevelReader)p_221884_, p_221885_)) {
            BlockIcicle.growStalactiteOrStalagmiteIfPossible(p_221883_, p_221884_, p_221885_, p_221886_);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_154040_) {
        Direction direction;
        BlockPos blockpos;
        Level levelaccessor = p_154040_.getLevel();
        Direction direction1 = BlockIcicle.calculateTipDirection((LevelReader)levelaccessor, blockpos = p_154040_.getClickedPos(), direction = p_154040_.getNearestLookingVerticalDirection().getOpposite());
        if (direction1 == null) {
            return null;
        }
        boolean flag = !p_154040_.isSecondaryUseActive();
        DripstoneThickness dripstonethickness = BlockIcicle.calculateDripstoneThickness((LevelReader)levelaccessor, blockpos, direction1, flag);
        return dripstonethickness == null ? null : (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)direction1)).setValue(THICKNESS, (Comparable)dripstonethickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelaccessor.getFluidState(blockpos).getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState p_154235_) {
        return (Boolean)p_154235_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : Fluids.EMPTY.defaultFluidState();
    }

    public VoxelShape getOcclusionShape(BlockState p_154170_, BlockGetter p_154171_, BlockPos p_154172_) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState p_154117_, BlockGetter p_154118_, BlockPos p_154119_, CollisionContext p_154120_) {
        DripstoneThickness dripstonethickness = (DripstoneThickness)p_154117_.getValue(THICKNESS);
        VoxelShape voxelshape = dripstonethickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (dripstonethickness == DripstoneThickness.TIP ? (p_154117_.getValue((Property)TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (dripstonethickness == DripstoneThickness.FRUSTUM ? FRUSTUM_SHAPE : (dripstonethickness == DripstoneThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE)));
        Vec3 vec3 = p_154117_.getOffset(p_154118_, p_154119_);
        return voxelshape.move(vec3.x, 0.0, vec3.z);
    }

    public boolean isCollisionShapeFullBlock(BlockState p_181235_, BlockGetter p_181236_, BlockPos p_181237_) {
        return false;
    }

    public float getMaxHorizontalOffset() {
        return 0.125f;
    }

    public void onBrokenAfterFall(Level p_154059_, BlockPos p_154060_, FallingBlockEntity p_154061_) {
        if (!p_154061_.isSilent()) {
            p_154059_.levelEvent(1045, p_154060_, 0);
        }
    }

    public DamageSource getFallDamageSource(Entity entity) {
        return entity.level().damageSources().stalagmite();
    }

    public Predicate<Entity> getHurtsEntitySelector() {
        return EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.LIVING_ENTITY_STILL_ALIVE);
    }

    private static void spawnFallingStalactite(BlockState p_154098_, ServerLevel p_154099_, BlockPos p_154100_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_154100_.mutable();
        BlockState blockstate = p_154098_;
        while (BlockIcicle.isStalactite(blockstate)) {
            FallingBlockEntity fallingblockentity = FallingBlockEntity.fall((Level)p_154099_, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate);
            if (BlockIcicle.isTip(blockstate, true)) {
                int i = Math.max(1 + p_154100_.getY() - blockpos$mutableblockpos.getY(), 6);
                float f = 1.0f * (float)i;
                fallingblockentity.setHurtsEntities(f, 40);
                break;
            }
            blockpos$mutableblockpos.move(Direction.DOWN);
            blockstate = p_154099_.getBlockState((BlockPos)blockpos$mutableblockpos);
        }
    }

    @VisibleForTesting
    public static void growStalactiteOrStalagmiteIfPossible(BlockState p_221888_, ServerLevel p_221889_, BlockPos p_221890_, RandomSource p_221891_) {
        BlockState blockstate2;
        BlockPos blockpos;
        BlockState blockstate1;
        BlockState blockstate = p_221889_.getBlockState(p_221890_.above(1));
        if (BlockIcicle.canGrow(blockstate, blockstate1 = p_221889_.getBlockState(p_221890_.above(2))) && (blockpos = BlockIcicle.findTip(p_221888_, (LevelAccessor)p_221889_, p_221890_, 7, false)) != null && BlockIcicle.canTipGrow(blockstate2 = p_221889_.getBlockState(blockpos), p_221889_, blockpos)) {
            if (p_221891_.nextBoolean()) {
                BlockIcicle.grow(p_221889_, blockpos, Direction.DOWN);
            } else {
                BlockIcicle.growStalagmiteBelow(p_221889_, blockpos);
            }
        }
    }

    private static void growStalagmiteBelow(ServerLevel p_154033_, BlockPos p_154034_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_154034_.mutable();
        for (int i = 0; i < 10; ++i) {
            blockpos$mutableblockpos.move(Direction.DOWN);
            BlockState blockstate = p_154033_.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (!blockstate.getFluidState().isEmpty()) {
                return;
            }
            if (BlockIcicle.isUnmergedTipWithDirection(blockstate, Direction.UP) && BlockIcicle.canTipGrow(blockstate, p_154033_, (BlockPos)blockpos$mutableblockpos)) {
                BlockIcicle.grow(p_154033_, (BlockPos)blockpos$mutableblockpos, Direction.UP);
                return;
            }
            if (!BlockIcicle.isValidPointedDripstonePlacement((LevelReader)p_154033_, (BlockPos)blockpos$mutableblockpos, Direction.UP) || p_154033_.isWaterAt(blockpos$mutableblockpos.below())) continue;
            BlockIcicle.grow(p_154033_, blockpos$mutableblockpos.below(), Direction.UP);
            return;
        }
    }

    private static void grow(ServerLevel p_154036_, BlockPos p_154037_, Direction p_154038_) {
        BlockPos blockpos = p_154037_.relative(p_154038_);
        BlockState blockstate = p_154036_.getBlockState(blockpos);
        if (BlockIcicle.isUnmergedTipWithDirection(blockstate, p_154038_.getOpposite())) {
            BlockIcicle.createMergedTips(blockstate, (LevelAccessor)p_154036_, blockpos);
        } else if (blockstate.isAir() || blockstate.is(Blocks.WATER)) {
            BlockIcicle.createDripstone((LevelAccessor)p_154036_, blockpos, p_154038_, DripstoneThickness.TIP);
        }
    }

    private static void createDripstone(LevelAccessor p_154088_, BlockPos p_154089_, Direction p_154090_, DripstoneThickness p_154091_) {
        BlockState blockstate = (BlockState)((BlockState)((BlockState)((Block)BlockRegistry.icicle.get()).defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)p_154090_)).setValue(THICKNESS, (Comparable)p_154091_)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(p_154088_.getFluidState(p_154089_).getType() == Fluids.WATER));
        p_154088_.setBlock(p_154089_, blockstate, 3);
    }

    private static void createMergedTips(BlockState p_154231_, LevelAccessor p_154232_, BlockPos p_154233_) {
        BlockPos blockpos;
        BlockPos blockpos1;
        if (p_154231_.getValue((Property)TIP_DIRECTION) == Direction.UP) {
            blockpos1 = p_154233_;
            blockpos = p_154233_.above();
        } else {
            blockpos = p_154233_;
            blockpos1 = p_154233_.below();
        }
        BlockIcicle.createDripstone(p_154232_, blockpos, Direction.DOWN, DripstoneThickness.TIP_MERGE);
        BlockIcicle.createDripstone(p_154232_, blockpos1, Direction.UP, DripstoneThickness.TIP_MERGE);
    }

    @Nullable
    private static BlockPos findTip(BlockState p_154131_, LevelAccessor p_154132_, BlockPos p_154133_, int p_154134_, boolean p_154135_) {
        if (BlockIcicle.isTip(p_154131_, p_154135_)) {
            return p_154133_;
        }
        Direction direction = (Direction)p_154131_.getValue((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> bipredicate = (p_202023_, p_202024_) -> p_202024_.is((Block)BlockRegistry.icicle.get()) && p_202024_.getValue((Property)TIP_DIRECTION) == direction;
        return BlockIcicle.findBlockVertical(p_154132_, p_154133_, direction.getAxisDirection(), bipredicate, p_154168_ -> BlockIcicle.isTip(p_154168_, p_154135_), p_154134_).orElse(null);
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader p_154191_, BlockPos p_154192_, Direction p_154193_) {
        Direction direction;
        if (BlockIcicle.isValidPointedDripstonePlacement(p_154191_, p_154192_, p_154193_)) {
            direction = p_154193_;
        } else {
            if (!BlockIcicle.isValidPointedDripstonePlacement(p_154191_, p_154192_, p_154193_.getOpposite())) {
                return null;
            }
            direction = p_154193_.getOpposite();
        }
        return direction;
    }

    private static DripstoneThickness calculateDripstoneThickness(LevelReader p_154093_, BlockPos p_154094_, Direction p_154095_, boolean p_154096_) {
        Direction direction = p_154095_.getOpposite();
        BlockState blockstate = p_154093_.getBlockState(p_154094_.relative(p_154095_));
        if (BlockIcicle.isPointedDripstoneWithDirection(blockstate, direction)) {
            return !p_154096_ && blockstate.getValue(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!BlockIcicle.isPointedDripstoneWithDirection(blockstate, p_154095_)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)blockstate.getValue(THICKNESS);
        if (dripstonethickness != DripstoneThickness.TIP && dripstonethickness != DripstoneThickness.TIP_MERGE) {
            BlockState blockstate1 = p_154093_.getBlockState(p_154094_.relative(direction));
            return !BlockIcicle.isPointedDripstoneWithDirection(blockstate1, p_154095_) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    private static boolean canTipGrow(BlockState p_154195_, ServerLevel p_154196_, BlockPos p_154197_) {
        Direction direction = (Direction)p_154195_.getValue((Property)TIP_DIRECTION);
        BlockPos blockpos = p_154197_.relative(direction);
        BlockState blockstate = p_154196_.getBlockState(blockpos);
        if (!blockstate.getFluidState().isEmpty()) {
            return false;
        }
        return blockstate.isAir() ? true : BlockIcicle.isUnmergedTipWithDirection(blockstate, direction.getOpposite());
    }

    private static boolean isValidPointedDripstonePlacement(LevelReader p_154222_, BlockPos p_154223_, Direction p_154224_) {
        BlockPos blockpos = p_154223_.relative(p_154224_.getOpposite());
        BlockState blockstate = p_154222_.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)p_154222_, blockpos, p_154224_) || BlockIcicle.isPointedDripstoneWithDirection(blockstate, p_154224_);
    }

    private static boolean isTip(BlockState p_154154_, boolean p_154155_) {
        if (!p_154154_.is((Block)BlockRegistry.icicle.get())) {
            return false;
        }
        DripstoneThickness dripstonethickness = (DripstoneThickness)p_154154_.getValue(THICKNESS);
        return dripstonethickness == DripstoneThickness.TIP || p_154155_ && dripstonethickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isUnmergedTipWithDirection(BlockState p_154144_, Direction p_154145_) {
        return BlockIcicle.isTip(p_154144_, false) && p_154144_.getValue((Property)TIP_DIRECTION) == p_154145_;
    }

    private static boolean isStalactite(BlockState p_154241_) {
        return BlockIcicle.isPointedDripstoneWithDirection(p_154241_, Direction.DOWN);
    }

    private static boolean isStalagmite(BlockState p_154243_) {
        return BlockIcicle.isPointedDripstoneWithDirection(p_154243_, Direction.UP);
    }

    private static boolean isStalactiteStartPos(BlockState p_154204_, LevelReader p_154205_, BlockPos p_154206_) {
        return BlockIcicle.isStalactite(p_154204_) && !p_154205_.getBlockState(p_154206_.above()).is((Block)BlockRegistry.icicle.get());
    }

    public boolean isPathfindable(BlockState p_154112_, BlockGetter p_154113_, BlockPos p_154114_, PathComputationType p_154115_) {
        return false;
    }

    private static boolean isPointedDripstoneWithDirection(BlockState p_154208_, Direction p_154209_) {
        return p_154208_.is((Block)BlockRegistry.icicle.get()) && p_154208_.getValue((Property)TIP_DIRECTION) == p_154209_;
    }

    private static boolean canGrow(BlockState p_154141_, BlockState p_154142_) {
        return p_154141_.is(BlockTags.ICE) || p_154142_.is((Block)BlockRegistry.icicle.get());
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor p_202007_, BlockPos p_202008_, Direction.AxisDirection p_202009_, BiPredicate<BlockPos, BlockState> p_202010_, Predicate<BlockState> p_202011_, int p_202012_) {
        Direction direction = Direction.get((Direction.AxisDirection)p_202009_, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_202008_.mutable();
        for (int i = 1; i < p_202012_; ++i) {
            blockpos$mutableblockpos.move(direction);
            BlockState blockstate = p_202007_.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (p_202011_.test(blockstate)) {
                return Optional.of(blockpos$mutableblockpos.immutable());
            }
            if (!p_202007_.isOutsideBuildHeight(blockpos$mutableblockpos.getY()) && p_202010_.test((BlockPos)blockpos$mutableblockpos, blockstate)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }
}

