/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.iceika;

import com.mojang.serialization.MapCodec;
import divinerpg.blocks.iceika.RedstoneBooster;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.Nullable;

public class RedstoneLimiter
extends DiodeBlock {
    public static final MapCodec<RedstoneLimiter> CODEC = RedstoneLimiter.simpleCodec(RedstoneLimiter::new);

    public RedstoneLimiter(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED});
    }

    protected MapCodec<? extends DiodeBlock> codec() {
        return CODEC;
    }

    protected int getDelay(BlockState blockState) {
        return 2;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    protected int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockState.getValue((Property)FACING) == side && (Boolean)blockState.getValue((Property)POWERED) != false ? 15 : 0;
    }

    protected boolean shouldTurnOn(Level level, BlockPos pos, BlockState state) {
        return RedstoneBooster.getCombinedInputSignal(level, pos, (Direction)state.getValue((Property)FACING)) > 15;
    }

    protected void checkTickOnNeighbor(Level level, BlockPos pos, BlockState state) {
        if (!level.getBlockTicks().willTickThisTick(pos, (Object)this)) {
            TickPriority tickpriority = TickPriority.HIGH;
            if (this.shouldPrioritize((BlockGetter)level, pos, state)) {
                tickpriority = TickPriority.EXTREMELY_HIGH;
            } else if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                tickpriority = TickPriority.VERY_HIGH;
            }
            level.scheduleTick(pos, (Block)this, this.getDelay(state), tickpriority);
        }
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        boolean shouldpower = this.shouldTurnOn((Level)level, pos, state);
        if (shouldpower ^ (Boolean)state.getValue((Property)POWERED)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(shouldpower)), 3);
        }
    }
}

