/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.twilight;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Duncap
extends BushBlock {
    public static final VoxelShape SHAPENORTH = Block.box((double)2.0, (double)0.0, (double)7.0, (double)14.0, (double)16.0, (double)16.0);
    public static final VoxelShape SHAPESOUTH = Block.box((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)9.0);
    public static final VoxelShape SHAPEWEST = Block.box((double)7.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0, (double)14.0);
    public static final VoxelShape SHAPEEAST = Block.box((double)0.0, (double)0.0, (double)2.0, (double)9.0, (double)16.0, (double)14.0);
    public static final MapCodec<Duncap> CODEC = Duncap.simpleCodec(Duncap::new);

    public Duncap() {
        this(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DRIPSTONE_BLOCK));
    }

    public Duncap(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)Direction.NORTH));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        for (Direction d : Direction.Plane.HORIZONTAL) {
            BlockPos p = pos.relative(d);
            if (!level.getBlockState(p).isFaceSturdy(level, p, d.getOpposite())) continue;
            return true;
        }
        return false;
    }

    protected boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        Direction d = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        BlockPos p = pos.relative(d.getOpposite());
        return level.getBlockState(p).isFaceSturdy((BlockGetter)level, p, d);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.getValue((Property)HorizontalDirectionalBlock.FACING);
        return switch (direction) {
            case Direction.SOUTH -> SHAPESOUTH;
            case Direction.WEST -> SHAPEWEST;
            case Direction.EAST -> SHAPEEAST;
            default -> SHAPENORTH;
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HorizontalDirectionalBlock.FACING});
    }
}

