/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.twilight;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.ItemAbilities;

public class LandVine
extends Block
implements BonemealableBlock {
    public static final VoxelShape WEST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    public static final VoxelShape EAST_AABB = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    public static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    public static final BooleanProperty[] PROPERTIES = new BooleanProperty[]{BlockStateProperties.NORTH, BlockStateProperties.SOUTH, BlockStateProperties.WEST, BlockStateProperties.EAST};
    final Map<BlockState, VoxelShape> shapesCache;

    public LandVine() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.VINE));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.BOTTOM, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = ImmutableMap.copyOf(this.stateDefinition.getPossibleStates().stream().collect(Collectors.toMap(Function.identity(), LandVine::calculateShape)));
    }

    public static BooleanProperty byDirection(Direction d) {
        return PROPERTIES[d.ordinal() - 2];
    }

    static VoxelShape calculateShape(BlockState state) {
        VoxelShape voxelshape = Shapes.empty();
        if (((Boolean)state.getValue((Property)BlockStateProperties.NORTH)).booleanValue()) {
            voxelshape = NORTH_AABB;
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.SOUTH)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.EAST)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.WEST)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
        }
        return voxelshape.isEmpty() ? Shapes.block() : voxelshape;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.shapesCache.get(state);
    }

    protected boolean propagatesSkylightDown(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        float baseProgress = super.getDestroyProgress(state, player, level, pos);
        return player.getMainHandItem().canPerformAction(ItemAbilities.SHEARS_DIG) ? baseProgress * 2.0f : baseProgress;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (player.getMainHandItem().getItem() instanceof ShearsItem) {
            player.awardStat(Stats.ITEM_USED.get((Object)player.getMainHandItem().getItem()));
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    boolean canSupportAtFace(BlockGetter level, BlockPos pos, Direction direction) {
        if (direction.getAxis() == Direction.Axis.Y) {
            return false;
        }
        BlockPos blockpos = pos.relative(direction);
        if (VineBlock.isAcceptableNeighbour((BlockGetter)level, (BlockPos)blockpos, (Direction)direction)) {
            return true;
        }
        BlockState blockstate = level.getBlockState(pos.above());
        return blockstate.is((Block)this) && (Boolean)blockstate.getValue((Property)LandVine.byDirection(direction)) != false;
    }

    BlockState getUpdatedState(BlockState state, BlockGetter level, BlockPos pos) {
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        state = (BlockState)state.setValue((Property)BlockStateProperties.BOTTOM, (Comparable)Boolean.valueOf(!belowState.is((Block)this) && !belowState.isFaceSturdy(level, belowPos, Direction.UP)));
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            state = (BlockState)state.setValue((Property)LandVine.byDirection(direction), (Comparable)Boolean.valueOf(this.canSupportAtFace(level, pos, direction)));
        }
        return state;
    }

    protected BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockState blockstate = this.getUpdatedState(state, (BlockGetter)level, currentPos);
        return LandVine.hasFaces(blockstate) ? blockstate : state;
    }

    static boolean hasFaces(BlockState state) {
        for (BooleanProperty property : PROPERTIES) {
            if (!((Boolean)state.getValue((Property)property)).booleanValue()) continue;
            return true;
        }
        return false;
    }

    boolean canSpread(BlockGetter blockReader, BlockPos pos) {
        Iterable iterable = BlockPos.betweenClosed((int)(pos.getX() - 4), (int)(pos.getY() - 1), (int)(pos.getZ() - 4), (int)(pos.getX() + 4), (int)(pos.getY() + 1), (int)(pos.getZ() + 4));
        int j = 5;
        for (BlockPos blockpos : iterable) {
            if (!blockReader.getBlockState(blockpos).is((Block)this) || --j != 0) continue;
            return false;
        }
        return true;
    }

    void spread(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.BOTTOM)).booleanValue() && level.getBlockState(pos.below()).isAir()) {
            int i;
            BlockPos.MutableBlockPos m = pos.mutable();
            for (i = 0; i < 3 && level.getBlockState((BlockPos)m.move(Direction.UP)).is((Block)this); ++i) {
            }
            if (i < 3) {
                level.setBlock(pos.below(), state, 3);
            }
        } else {
            BlockState spreadState;
            BlockPos relative;
            Direction direction = Direction.Plane.HORIZONTAL.getRandomDirection(random);
            if (!((Boolean)state.getValue((Property)LandVine.byDirection(direction))).booleanValue() && this.canSpread((BlockGetter)level, pos) && level.getBlockState(relative = pos.relative(direction)).isAir() && LandVine.hasFaces(spreadState = this.getUpdatedState(state, (BlockGetter)level, relative))) {
                level.setBlock(relative, spreadState, 2);
            }
        }
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.getGameRules().getBoolean(GameRules.RULE_DO_VINES_SPREAD) && level.random.nextInt(4) == 0 && level.isAreaLoaded(pos, 4)) {
            this.spread(state, level, pos, random);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState blockstate = context.getLevel().getBlockState(context.getClickedPos());
        boolean sameBlock = blockstate.is((Block)this);
        BlockState state = sameBlock ? blockstate : this.defaultBlockState();
        for (Direction direction : context.getNearestLookingDirections()) {
            boolean flag1;
            if (direction.getAxis() == Direction.Axis.Y) continue;
            BooleanProperty booleanproperty = LandVine.byDirection(direction);
            boolean bl = flag1 = sameBlock && (Boolean)blockstate.getValue((Property)booleanproperty) != false;
            if (flag1 || !this.canSupportAtFace((BlockGetter)context.getLevel(), context.getClickedPos(), direction)) continue;
            return (BlockState)state.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(true));
        }
        return sameBlock ? state : null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.NORTH, BlockStateProperties.EAST, BlockStateProperties.SOUTH, BlockStateProperties.WEST, BlockStateProperties.BOTTOM});
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)BlockStateProperties.NORTH, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.SOUTH)))).setValue((Property)BlockStateProperties.EAST, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.WEST)))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.NORTH)))).setValue((Property)BlockStateProperties.WEST, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)BlockStateProperties.NORTH, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.EAST)))).setValue((Property)BlockStateProperties.EAST, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.SOUTH)))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.WEST)))).setValue((Property)BlockStateProperties.WEST, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)BlockStateProperties.NORTH, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.WEST)))).setValue((Property)BlockStateProperties.EAST, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.NORTH)))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.EAST)))).setValue((Property)BlockStateProperties.WEST, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.SOUTH)));
            default -> state;
        };
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.setValue((Property)BlockStateProperties.NORTH, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.SOUTH)))).setValue((Property)BlockStateProperties.SOUTH, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.setValue((Property)BlockStateProperties.EAST, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.WEST)))).setValue((Property)BlockStateProperties.WEST, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.EAST)));
            default -> super.mirror(state, mirror);
        };
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        blockState = this.getUpdatedState(blockState, (BlockGetter)serverLevel, blockPos);
        serverLevel.setBlock(blockPos, blockState, 3);
        this.spread(blockState, serverLevel, blockPos, randomSource);
    }

    public int getFlammability(BlockState state, BlockGetter getter, BlockPos pos, Direction face) {
        return 100;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter getter, BlockPos pos, Direction face) {
        return 15;
    }
}

