/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.twilight;

import divinerpg.blocks.twilight.LandVine;
import divinerpg.registries.BlockRegistry;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.common.ItemAbilities;

public class LandVineStem
extends Block
implements BonemealableBlock {
    public LandVineStem() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GRASS_BLOCK).mapColor(MapColor.PLANT).sound(SoundType.VINE).ignitedByLava());
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        float baseProgress = super.getDestroyProgress(state, player, level, pos);
        return player.getMainHandItem().canPerformAction(ItemAbilities.SHEARS_DIG) ? baseProgress * 5.0f : baseProgress;
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (player.getMainHandItem().getItem() instanceof ShearsItem) {
            player.awardStat(Stats.ITEM_USED.get((Object)player.getMainHandItem().getItem()));
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (level.getGameRules().getBoolean(GameRules.RULE_DO_VINES_SPREAD) && level.isAreaLoaded(pos, 4)) {
            this.spread(level, pos, random);
        }
    }

    void spread(ServerLevel level, BlockPos pos, RandomSource random) {
        Direction d = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        if (level.getBlockState(pos.relative(d)).isAir()) {
            level.setBlock(pos.relative(d), (BlockState)((Block)BlockRegistry.landVine.get()).defaultBlockState().setValue((Property)LandVine.byDirection(d.getOpposite()), (Comparable)Boolean.valueOf(true)), 3);
        }
        int dx = random.nextBoolean() ? 1 : -1;
        int dy = random.nextBoolean() ? 1 : -1;
        int dz = random.nextBoolean() ? 1 : -1;
        int x = 0;
        while (Math.abs(x) < 5) {
            int y = 0;
            while (Math.abs(y) < 5) {
                int z;
                int n = z = Math.abs(x) < 2 && Math.abs(y) < 2 ? 2 * dz : 0;
                while (Math.abs(z) < 5) {
                    if (level.getBlockState(pos.offset(x, y, z)).is((Block)this)) {
                        int dist = Math.abs(x) + Math.abs(y) + Math.abs(z);
                        int[][] offsets = new int[][]{{dx, 0, 0}, {0, dy, 0}, {0, 0, dz}, {dx, dy, 0}, {dx, 0, dz}, {0, dy, dz}, {dx, dy, dz}};
                        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
                        for (int[] offset : offsets) {
                            if (Math.abs(x - offset[0]) + Math.abs(y - offset[1]) + Math.abs(z - offset[2]) >= dist) continue;
                            BlockPos p = pos.offset(offset[0], offset[1], offset[2]);
                            BlockState state = level.getBlockState(p);
                            if (state.is((Block)this)) {
                                return;
                            }
                            if (!state.isAir() && !state.is(BlockRegistry.landVine)) continue;
                            candidates.add(p);
                        }
                        if (!candidates.isEmpty()) {
                            level.setBlock((BlockPos)candidates.get(random.nextInt(candidates.size())), this.defaultBlockState(), 3);
                        }
                        return;
                    }
                    z += dz;
                }
                y += dy;
            }
            x += dx;
        }
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        this.spread(serverLevel, blockPos, randomSource);
    }

    public int getFlammability(BlockState state, BlockGetter getter, BlockPos pos, Direction face) {
        return 60;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter getter, BlockPos pos, Direction face) {
        return 30;
    }
}

