/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vanilla;

import com.mojang.serialization.MapCodec;
import divinerpg.block_entities.block.InserterBlockEntity;
import divinerpg.registries.BlockEntityRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public class BlockInserter
extends BaseEntityBlock {
    public static final MapCodec<BlockInserter> CODEC = BlockInserter.simpleCodec(BlockInserter::new);

    public MapCodec<BlockInserter> codec() {
        return CODEC;
    }

    public BlockInserter() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.HOPPER));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.FACING, (Comparable)Direction.NORTH));
    }

    public BlockInserter(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.ENABLED, BlockStateProperties.FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)context.getNearestLookingDirection());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)BlockStateProperties.FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mir) {
        return this.rotate(state, mir.getRotation((Direction)state.getValue((Property)BlockStateProperties.FACING)));
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return ((BlockEntityType)BlockEntityRegistry.INSERTER.get()).create(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockInserter.createCrateTicker(level, type, (BlockEntityType<? extends InserterBlockEntity>)((BlockEntityType)BlockEntityRegistry.INSERTER.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createCrateTicker(Level level, BlockEntityType<T> type, BlockEntityType<? extends InserterBlockEntity> entityType) {
        return level.isClientSide ? null : BlockInserter.createTickerHelper(type, entityType, InserterBlockEntity::serverTick);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos p, boolean b) {
        boolean signal;
        boolean bl = signal = !level.hasNeighborSignal(pos);
        if ((Boolean)state.getValue((Property)BlockStateProperties.ENABLED) ^ signal) {
            level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.ENABLED, (Comparable)Boolean.valueOf(signal)), 4);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState s, boolean b) {
        if (!state.is(s.getBlock()) || !s.hasBlockEntity()) {
            InserterBlockEntity block;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof InserterBlockEntity && !(block = (InserterBlockEntity)blockEntity).isEmpty()) {
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)block);
            }
            level.removeBlockEntity(pos);
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof InserterBlockEntity) {
            InserterBlockEntity block = (InserterBlockEntity)blockEntity;
            if (!block.isEmpty()) {
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)block);
            }
            level.removeBlockEntity(pos);
            level.updateNeighbourForOutputSignal(pos, (Block)this);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }
}

