/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vanilla;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;

public class BlockMobPumpkin
extends HorizontalDirectionalBlock {
    public static final MapCodec<BlockMobPumpkin> CODEC = BlockMobPumpkin.simpleCodec(BlockMobPumpkin::new);
    private Supplier<SoundEvent> sound;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public MapCodec<BlockMobPumpkin> codec() {
        return CODEC;
    }

    public BlockMobPumpkin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockMobPumpkin(Supplier<SoundEvent> sound, MapColor color) {
        super(BlockBehaviour.Properties.of().strength(1.0f).pushReaction(PushReaction.DESTROY).sound(SoundType.WOOD).instrument(NoteBlockInstrument.DIDGERIDOO).mapColor(color));
        this.sound = sound;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        if (player.isCrouching() && !player.getMainHandItem().isEmpty() || this.sound == null) {
            return InteractionResult.PASS;
        }
        worldIn.playSound(player, pos, this.sound.get(), SoundSource.BLOCKS, 3.0f, 1.0f);
        return InteractionResult.SUCCESS;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }
}

