/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vanilla;

import divinerpg.blocks.base.BlockMod;
import divinerpg.registries.BlockRegistry;
import divinerpg.registries.TagRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MinerBlock
extends BlockMod {
    public MinerBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.DROPPER));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)DirectionalBlock.FACING, (Comparable)Direction.NORTH)).setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DirectionalBlock.FACING, BlockStateProperties.TRIGGERED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)DirectionalBlock.FACING, (Comparable)context.getNearestLookingDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)DirectionalBlock.FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)DirectionalBlock.FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mir) {
        return this.rotate(state, mir.getRotation((Direction)state.getValue((Property)DirectionalBlock.FACING)));
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos p, boolean b) {
        if (level instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)level;
            boolean hasSignal = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above());
            boolean triggered = (Boolean)state.getValue((Property)BlockStateProperties.TRIGGERED);
            if (triggered && !hasSignal) {
                level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
            } else if (hasSignal && !triggered) {
                level.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
                p = pos.relative((Direction)state.getValue((Property)BlockStateProperties.FACING));
                if (!s.getBlockState(p).is(BlockTags.INCORRECT_FOR_DIAMOND_TOOL) && s.getBlockState(p).is(TagRegistry.MINEABLE_WITH_SHICKAXE)) {
                    s.destroyBlock(p, true);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, context, tooltip, flagIn);
        if (stack.getItem() != BlockRegistry.placer.asItem()) {
            tooltip.add(1, LocalizeUtils.efficiency("\u221e"));
            tooltip.add(LocalizeUtils.harvestLevel((Component)Component.literal((String)Items.OBSIDIAN.getName(stack).getString()).withColor(5257328)));
        }
    }
}

