/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vethea;

import com.mojang.serialization.MapCodec;
import divinerpg.block_entities.block.DreamLampBlockEntity;
import divinerpg.registries.BlockEntityRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BlockDreamLamp
extends BaseEntityBlock {
    public static final MapCodec<BlockDreamLamp> CODEC = BlockDreamLamp.simpleCodec(BlockDreamLamp::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public MapCodec<BlockDreamLamp> codec() {
        return CODEC;
    }

    public BlockDreamLamp(BlockBehaviour.Properties properties) {
        super(properties.strength(0.3f).sound(SoundType.GLASS));
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : BlockDreamLamp.createTickerHelper(type, (BlockEntityType)((BlockEntityType)BlockEntityRegistry.DREAM_LAMP.get()), DreamLampBlockEntity::serverTick);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED});
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState st, boolean b) {
        if (!state.is(st.getBlock())) {
            BlockEntity blockentity = level.getBlockEntity(pos);
            if (blockentity instanceof DreamLampBlockEntity) {
                if (level instanceof ServerLevel) {
                    Containers.dropContents((Level)level, (BlockPos)pos, (Container)((DreamLampBlockEntity)blockentity));
                }
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, st, b);
        }
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new DreamLampBlockEntity(pos, state);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockentity = level.getBlockEntity(pos);
        if (blockentity instanceof DreamLampBlockEntity) {
            player.openMenu((MenuProvider)blockentity);
        }
        return InteractionResult.CONSUME;
    }
}

