/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vethea;

import com.mojang.serialization.MapCodec;
import divinerpg.block_entities.block.KarosDispenser;
import divinerpg.entities.projectile.arrows.KarosArrow;
import divinerpg.registries.ItemRegistry;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.DropperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BlockKarosDispenser
extends BaseEntityBlock {
    public static final MapCodec<BlockKarosDispenser> CODEC = BlockKarosDispenser.simpleCodec(BlockKarosDispenser::new);
    public static final DirectionProperty FACING = DirectionalBlock.FACING;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;
    private static final Map<Item, DispenseItemBehavior> DISPENSER_REGISTRY = (Map)Util.make((Object)new Object2ObjectOpenHashMap(), p_212564_0_ -> p_212564_0_.defaultReturnValue((Object)new DefaultDispenseItemBehavior()));

    public MapCodec<BlockKarosDispenser> codec() {
        return CODEC;
    }

    public static void registerBehavior(ItemLike provider, DispenseItemBehavior behavior) {
        DISPENSER_REGISTRY.put(provider.asItem(), behavior);
    }

    public BlockKarosDispenser(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.PLANT).strength(-1.0f, 3600000.0f).instrument(NoteBlockInstrument.BASEDRUM).noLootTable());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult use(BlockState p_225533_1_, Level p_225533_2_, BlockPos p_225533_3_, Player p_225533_4_, InteractionHand p_225533_5_, BlockHitResult p_225533_6_) {
        if (p_225533_2_.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = p_225533_2_.getBlockEntity(p_225533_3_);
        if (blockEntity instanceof DispenserBlockEntity) {
            p_225533_4_.openMenu((MenuProvider)((DispenserBlockEntity)blockEntity));
            if (blockEntity instanceof DropperBlockEntity) {
                p_225533_4_.awardStat(Stats.INSPECT_DROPPER);
            } else {
                p_225533_4_.awardStat(Stats.INSPECT_DISPENSER);
            }
        }
        return InteractionResult.CONSUME;
    }

    public void dispenseFrom(ServerLevel world, BlockPos pos) {
        double var5 = pos.getX();
        double var7 = pos.getY();
        double var9 = pos.getZ();
        Direction direction = (Direction)world.getBlockState(pos).getValue((Property)FACING);
        KarosArrow var11 = new KarosArrow((Level)world, var5 + 0.5 + (double)direction.getStepX(), var7 + 0.5, var9 + 0.5 + (double)direction.getStepZ(), new ItemStack((ItemLike)ItemRegistry.karos_arrow.get()), null);
        var11.powerMultiplier = 1.7143f;
        double var12 = world.random.nextDouble() * 0.1 + 0.9;
        var11.setDeltaMovement((double)direction.getStepX() * var12, 0.0, (double)direction.getStepZ() * var12);
        var11.setDeltaMovement(var11.getDeltaMovement().x, var11.getDeltaMovement().y + 0.0, var11.getDeltaMovement().z);
        world.addFreshEntity((Entity)var11);
    }

    protected DispenseItemBehavior getDispenseMethod(ItemStack stack) {
        return DISPENSER_REGISTRY.get(stack.getItem());
    }

    public void neighborChanged(BlockState p_220069_1_, Level p_220069_2_, BlockPos p_220069_3_, Block p_220069_4_, BlockPos p_220069_5_, boolean p_220069_6_) {
        boolean flag = p_220069_2_.hasNeighborSignal(p_220069_3_) || p_220069_2_.hasNeighborSignal(p_220069_3_.above());
        boolean flag1 = (Boolean)p_220069_1_.getValue((Property)TRIGGERED);
        if (flag && !flag1) {
            p_220069_2_.getBlockTicks().willTickThisTick(p_220069_3_, (Object)this);
            p_220069_2_.setBlock(p_220069_3_, (BlockState)p_220069_1_.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(true)), 4);
        } else if (!flag && flag1) {
            p_220069_2_.setBlock(p_220069_3_, (BlockState)p_220069_1_.setValue((Property)TRIGGERED, (Comparable)Boolean.valueOf(false)), 4);
        }
    }

    public void tick(BlockState p_225534_1_, ServerLevel p_225534_2_, BlockPos p_225534_3_, Random p_225534_4_) {
        this.dispenseFrom(p_225534_2_, p_225534_3_);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState p_153216_) {
        return new KarosDispenser(p_153215_, p_153216_);
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_196258_1_) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)p_196258_1_.getNearestLookingDirection().getOpposite());
    }

    public void onRemove(BlockState p_196243_1_, Level p_196243_2_, BlockPos p_196243_3_, BlockState p_196243_4_, boolean p_196243_5_) {
        if (!p_196243_1_.is(p_196243_4_.getBlock())) {
            BlockEntity blockEntity = p_196243_2_.getBlockEntity(p_196243_3_);
            if (blockEntity instanceof DispenserBlockEntity) {
                Containers.dropContents((Level)p_196243_2_, (BlockPos)p_196243_3_, (Container)((DispenserBlockEntity)blockEntity));
                p_196243_2_.updateNeighbourForOutputSignal(p_196243_3_, (Block)this);
            }
            super.onRemove(p_196243_1_, p_196243_2_, p_196243_3_, p_196243_4_, p_196243_5_);
        }
    }

    public static Position getDispensePosition(BlockSource p_149939_0_) {
        Direction direction = (Direction)p_149939_0_.state().getValue((Property)FACING);
        double d0 = (double)p_149939_0_.pos().getX() + 0.7 * (double)direction.getStepX();
        double d1 = (double)p_149939_0_.pos().getY() + 0.7 * (double)direction.getStepY();
        double d2 = (double)p_149939_0_.pos().getZ() + 0.7 * (double)direction.getStepZ();
        return new Vec3(d0, d1, d2);
    }

    public boolean hasAnalogOutputSignal(BlockState p_149740_1_) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState p_180641_1_, Level p_180641_2_, BlockPos p_180641_3_) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)p_180641_2_.getBlockEntity(p_180641_3_));
    }

    public RenderShape getRenderShape(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState p_185499_1_, Rotation p_185499_2_) {
        return (BlockState)p_185499_1_.setValue((Property)FACING, (Comparable)p_185499_2_.rotate((Direction)p_185499_1_.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState p_185471_1_, Mirror p_185471_2_) {
        return p_185471_1_.rotate(p_185471_2_.getRotation((Direction)p_185471_1_.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.add(new Property[]{FACING, TRIGGERED});
    }
}

