/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vethea;

import divinerpg.block_entities.NightmareBedBlockEntity;
import divinerpg.blocks.vethea.VetheaPortal;
import divinerpg.config.CommonConfig;
import divinerpg.registries.BlockRegistry;
import divinerpg.util.LocalizeUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.TickPriority;

public class BlockNightmareBed
extends BedBlock {
    public BlockNightmareBed() {
        super(DyeColor.BLACK, BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GRAY).ignitedByLava().pushReaction(PushReaction.DESTROY).strength(0.2f).sound(SoundType.WOOD));
    }

    public InteractionResult useWithoutItem(BlockState state, Level worldIn, BlockPos pos, Player player, BlockHitResult hit) {
        if (player.getInventory().isEmpty() || !CommonConfig.Values.SAFER_VETHEA) {
            if (!worldIn.isClientSide()) {
                if (state.getValue((Property)PART) != BedPart.HEAD && !(state = worldIn.getBlockState(pos = pos.relative((Direction)state.getValue((Property)FACING)))).is((Block)this)) {
                    return InteractionResult.CONSUME;
                }
                if (((Boolean)state.getValue((Property)OCCUPIED)).booleanValue()) {
                    player.displayClientMessage((Component)Component.translatable((String)"block.minecraft.bed.occupied"), true);
                    return InteractionResult.SUCCESS;
                }
                if (worldIn.getChunkSource().getLightEngine().getLayerListener(LightLayer.BLOCK).getLightValue(pos) < 7 && worldIn.getChunkSource().getLightEngine().getLayerListener(LightLayer.SKY).getLightValue(pos) < 7) {
                    ((ServerPlayer)player).setRespawnPosition(worldIn.dimension(), pos, player.getYRot(), false, true);
                    player.startSleepInBed(pos).ifLeft(problem -> {
                        if (problem.getMessage() != null) {
                            player.displayClientMessage(problem.getMessage(), true);
                        }
                    });
                    return InteractionResult.SUCCESS;
                }
                Component message = LocalizeUtils.clientMessage(ChatFormatting.RED, "nightmare_bed.restrict", player.getDisplayName());
                player.displayClientMessage(message, true);
            }
        } else {
            Component message = LocalizeUtils.clientMessage(ChatFormatting.RED, "nightmare_bed.inventory_full", player.getDisplayName());
            player.displayClientMessage(message, true);
        }
        return InteractionResult.CONSUME;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new NightmareBedBlockEntity(pos, state);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)OCCUPIED)).booleanValue()) {
            List list = level.getEntitiesOfClass(LivingEntity.class, new AABB(pos), LivingEntity::isSleeping);
            for (LivingEntity e : list) {
                e.changeDimension(((VetheaPortal)BlockRegistry.vetheaPortal.get()).getPortalDestination(level, (Entity)e, pos));
            }
            this.setBedOccupied(state, (Level)level, pos, null, false);
        }
    }

    public void setBedOccupied(BlockState state, Level level, BlockPos pos, LivingEntity sleeper, boolean occupied) {
        super.setBedOccupied(state, level, pos, sleeper, occupied);
        if (occupied) {
            level.scheduleTick(pos, (Block)this, 70, TickPriority.HIGH);
        }
    }

    public Optional<ServerPlayer.RespawnPosAngle> getRespawnPosition(BlockState state, EntityType<?> type, LevelReader level, BlockPos pos, float angle) {
        return BedBlock.findStandUpPosition(type, (CollisionGetter)level, (BlockPos)pos, (Direction)((Direction)state.getValue((Property)BedBlock.FACING)), (float)angle).map(v -> ServerPlayer.RespawnPosAngle.of((Vec3)v, (BlockPos)pos));
    }
}

