/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.blocks.vethea;

import divinerpg.blocks.base.BlockModUnbreakable;
import divinerpg.util.LocalizeUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;

public abstract class BlockVetheaAltar
extends BlockModUnbreakable {
    protected BlockVetheaAltar(MapColor color) {
        super(color);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (stack.getItem() == this.acceptedItem()) {
            if (world.getDifficulty() == Difficulty.PEACEFUL) {
                player.displayClientMessage(LocalizeUtils.clientMessage(ChatFormatting.AQUA, "boss.peaceful", new Object[0]), true);
                return ItemInteractionResult.CONSUME;
            }
            player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
            player.getCooldowns().addCooldown(stack.getItem(), 40);
            stack.consume(1, (LivingEntity)player);
            this.spawnBoss(world, pos);
            return ItemInteractionResult.SUCCESS;
        }
        this.onFailure();
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void spawnBoss(Level worldIn, BlockPos pos) {
        if (!worldIn.isClientSide) {
            this.getBoss(worldIn).getType().spawn((ServerLevel)worldIn, ItemStack.EMPTY, null, pos, MobSpawnType.MOB_SUMMONED, false, false);
        }
    }

    protected abstract Item acceptedItem();

    protected abstract LivingEntity getBoss(Level var1);

    protected abstract void onFailure();
}

